/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.sql;

import com.queryflow.common.QueryFlowException;
import java.util.LinkedList;
import java.util.List;

public abstract class Where<T> {
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String AND_NEW = ") AND (";
    private static final String OR_NEW = ") OR (";
    protected List<Object> values = new LinkedList<Object>();
    protected StringBuilder appender = new StringBuilder();
    protected boolean hasWhere = false;

    public T where() {
        this.appender.append(" WHERE (");
        this.hasWhere = true;
        return (T)this;
    }

    public T where(String condition) {
        this.appender.append(" WHERE (").append(condition);
        this.hasWhere = true;
        return (T)this;
    }

    public T and() {
        this.appender.append(AND);
        return (T)this;
    }

    public T and(String condition) {
        this.appender.append(AND).append(condition);
        return (T)this;
    }

    public T andNew() {
        this.appender.append(AND_NEW);
        return (T)this;
    }

    public T or() {
        this.appender.append(OR);
        return (T)this;
    }

    public T orNew() {
        this.appender.append(OR_NEW);
        return (T)this;
    }

    public T isNull(String column) {
        this.appender.append(column).append(" IS NULL ");
        return (T)this;
    }

    public T isNotNull(String column) {
        this.appender.append(column).append(" IS NOT NULL ");
        return (T)this;
    }

    public T like(String column, Object value) {
        this.appender.append(column).append(" LIKE ?");
        this.values.add(value);
        return (T)this;
    }

    public T notLike(String column, Object value) {
        this.appender.append(column).append(" NOT LIKE ?");
        this.values.add(value);
        return (T)this;
    }

    public T in(String column, Object ... values) {
        this.appender.append(column).append(" IN (");
        if (values == null || values.length == 0) {
            throw new QueryFlowException("");
        }
        this.addValueAndMark(values);
        this.appender.append(")");
        return (T)this;
    }

    public T notIn(String column, Object ... values) {
        this.appender.append(column).append(" NOT IN (");
        if (values == null || values.length == 0) {
            throw new QueryFlowException("");
        }
        this.addValueAndMark(values);
        this.appender.append(") ");
        return (T)this;
    }

    private void addValueAndMark(Object ... values) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            Object value = values[i];
            this.appender.append("?");
            if (i < len - 1) {
                this.appender.append(", ");
            }
            this.values.add(value);
        }
    }

    public T gt(String column, Object value) {
        this.appender.append(column).append(" > ?");
        this.values.add(value);
        return (T)this;
    }

    public T ge(String column, Object value) {
        this.appender.append(column).append(" >= ");
        this.values.add(value);
        return (T)this;
    }

    public T lt(String column, Object value) {
        this.appender.append(column).append(" < ?");
        this.values.add(value);
        return (T)this;
    }

    public T le(String column, Object value) {
        this.appender.append(column).append(" <= ?");
        this.values.add(value);
        return (T)this;
    }

    public T between(String column, Object smallValue, Object bigValue) {
        this.appender.append(column).append(" BETWEEN ? AND ?");
        this.values.add(smallValue);
        this.values.add(bigValue);
        return (T)this;
    }

    public T notBetween(String column, Object smallValue, Object bigValue) {
        this.appender.append(column).append(" NOT BETWEEN ? AND ?");
        this.values.add(smallValue);
        this.values.add(bigValue);
        return (T)this;
    }

    public T eq(String column, Object value) {
        this.appender.append(column).append(" = ?");
        this.values.add(value);
        return (T)this;
    }

    public T notEq(String column, Object value) {
        this.appender.append(column).append(" <> ?");
        this.values.add(value);
        return (T)this;
    }

    public List<Object> getValues() {
        return this.values;
    }
}

