/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.utils;

import com.queryflow.utils.Filter;
import com.queryflow.utils.Utils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner {
    private static final String DOT = ".";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private List<String> packageNames = new LinkedList<String>();
    private Filter<Class<?>> filter = new SampleClassFilter();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    private ClassScanner() {
    }

    public static ClassScanner newScanner() {
        return new ClassScanner();
    }

    public static ClassScanner newScanner(String ... packageNames) {
        return new ClassScanner().packageName(packageNames);
    }

    private ClassScanner packageName(String ... packageNames) {
        if (packageNames != null && packageNames.length > 0) {
            for (String packageName : packageNames) {
                if (!Utils.isNotEmpty(packageName)) continue;
                if (!packageName.endsWith(DOT)) {
                    packageName = packageName + DOT;
                }
                if (this.packageNames.contains(packageName)) continue;
                this.packageNames.add(packageName);
            }
        }
        return this;
    }

    public ClassScanner setFilter(Filter<Class<?>> filter) {
        if (filter != null) {
            this.filter = filter;
        }
        return this;
    }

    public Set<Class<?>> scan() {
        HashSet classes = new HashSet();
        for (String packageName : this.packageNames) {
            List<URL> pathUrls = this.getClassPathUrls(packageName);
            for (URL url : pathUrls) {
                this.fillClasses(packageName, url, classes);
            }
        }
        return classes;
    }

    private void fillClasses(String packageName, URL url, Set<Class<?>> classes) {
        String classPath = this.decodeClassPath(url.getPath());
        if (!classPath.equals("")) {
            File file = new File(classPath);
            if (url.getProtocol().equals("file")) {
                if (file.isFile()) {
                    this.processClassFile(packageName, file, classes);
                } else if (file.isDirectory()) {
                    this.processDri(packageName, file, classes);
                }
            } else if (url.getProtocol().equals("jar")) {
                this.processJarFile(packageName, file, classes);
            }
        }
    }

    private void processClassFile(String packageName, File file, Set<Class<?>> classes) {
        String className = file.getName();
        if (this.isClass(className)) {
            className = packageName + className.replace(CLASS_FILE_SUFFIX, "");
            this.fillClass(packageName, className, classes);
        }
    }

    private void processDri(String packageName, File file, Set<Class<?>> classes) {
        Utils.listFiles(file, (child, relativePath) -> {
            String className = child.getName();
            if (this.isClass(className)) {
                if (!(relativePath = relativePath.replace('/', '.')).endsWith(DOT)) {
                    relativePath = relativePath + DOT;
                }
                className = packageName + relativePath + className.replace(CLASS_FILE_SUFFIX, "");
                this.fillClass(packageName, className, classes);
            }
        });
    }

    private void processJarFile(String packageName, File file, Set<Class<?>> classes) {
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!this.isClass(entry.getName())) continue;
                String className = entry.getName().replace("/", DOT).replace(CLASS_FILE_SUFFIX, "");
                this.fillClass(packageName, className, classes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillClass(String packageName, String className, Set<Class<?>> classes) {
        if (className.startsWith(packageName)) {
            try {
                Class<?> clazz = Class.forName(className, false, this.classLoader);
                if (this.filter.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isClass(String name) {
        return name.endsWith(CLASS_FILE_SUFFIX);
    }

    private List<URL> getClassPathUrls(String packageName) {
        String packagePath = packageName.replace('.', '/');
        try {
            return Collections.list(this.classLoader.getResources(packagePath));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private String decodeClassPath(String classPath) {
        try {
            return URLDecoder.decode(classPath, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private static class SampleClassFilter
    implements Filter<Class<?>> {
        private SampleClassFilter() {
        }

        @Override
        public boolean accept(Class<?> aClass) {
            return true;
        }
    }
}

