/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.utils;

import com.queryflow.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public final class Converts {
    public static final String DATE_PATTERN = "yyyyMMddHHmmss";

    private Converts() {
    }

    public static String toStr(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static Character toCharacter(Object value, Character defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String strValue = value.toString();
        if (strValue.length() == 1) {
            return Character.valueOf(strValue.charAt(0));
        }
        return defaultValue;
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            return Boolean.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static Number toNumber(Object value, Class<?> targetClass) {
        if (value instanceof Number) {
            return (Number)value;
        }
        String str = value.toString();
        if (str.startsWith("0x")) {
            try {
                return new BigInteger(str.substring("0x".length()), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (str.startsWith("0b")) {
            try {
                return new BigInteger(str.substring("0b".length()), 2);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            Constructor<?> constructor = targetClass.getConstructor(String.class);
            return (Number)constructor.newInstance(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        Number number = Converts.toNumber(value, Byte.class);
        if (number == null) {
            return defaultValue;
        }
        return number.byteValue();
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        Number number = Converts.toNumber(value, Short.class);
        if (number == null) {
            return defaultValue;
        }
        return number.shortValue();
    }

    public static Integer toInteger(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        Number number = Converts.toNumber(value, Integer.class);
        if (number == null) {
            return defaultValue;
        }
        return number.intValue();
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        Number number = Converts.toNumber(value, Long.class);
        if (number == null) {
            return defaultValue;
        }
        return number.longValue();
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        Number number = Converts.toNumber(value, Float.class);
        if (number == null) {
            return defaultValue;
        }
        return Float.valueOf(number.floatValue());
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        Number number = Converts.toNumber(value, Double.class);
        if (number == null) {
            return defaultValue;
        }
        return number.doubleValue();
    }

    public static byte[] toBytes(Object value, byte[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        Class<?> valueClass = value.getClass();
        if (Byte.class.equals(valueClass)) {
            return new byte[]{(Byte)value};
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Byte[]) {
            Byte[] bytes = (Byte[])value;
            byte[] result = new byte[bytes.length];
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                result[i] = bytes[i];
            }
            return result;
        }
        if (value instanceof String) {
            try {
                return ((String)value).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return defaultValue;
            }
        }
        if (value instanceof InputStream) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream in = (InputStream)value;
            Utils.copy(in, baos);
            byte[] result = baos.toByteArray();
            Utils.close(baos);
            return result;
        }
        return defaultValue;
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        Number number = Converts.toNumber(value, BigDecimal.class);
        if (number == null) {
            return defaultValue;
        }
        return new BigDecimal(number.doubleValue());
    }

    public static Date toDate(Object value, Date defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        return defaultValue;
    }

    public static Time toTime(Object value, Time defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        return defaultValue;
    }

    public static Timestamp toTimestamp(Object value, Timestamp defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        return defaultValue;
    }

    public static java.util.Date toUtilDate(Object value, String pattern, java.util.Date defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (java.util.Date.class == value.getClass()) {
            return (java.util.Date)value;
        }
        if (value instanceof java.util.Date) {
            return new java.util.Date(((java.util.Date)value).getTime());
        }
        if (value instanceof String) {
            if (Utils.isEmpty(pattern)) {
                pattern = DATE_PATTERN;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            try {
                return sdf.parse((String)value);
            }
            catch (ParseException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Clob toClob(Object value, Clob defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Clob) {
            return (Clob)value;
        }
        if (value instanceof String) {
            try {
                return new SerialClob(((String)value).toCharArray());
            }
            catch (SQLException ignore) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static Blob toBlob(Object value, Blob defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Blob) {
            return (Blob)value;
        }
        if (value instanceof byte[]) {
            try {
                return new SerialBlob((byte[])value);
            }
            catch (SQLException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static <T> T to(Class<T> clazz, Object value) {
        Comparable<Boolean> result = null;
        if (value == null && clazz.isPrimitive()) {
            result = Boolean.TYPE.equals(clazz) ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        if (clazz.isInstance(value)) {
            result = value;
        } else if (String.class.equals(clazz)) {
            result = Converts.toStr(value, null);
        } else if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            result = Converts.toBoolean(value, false);
        } else if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
            result = Converts.toCharacter(value, Character.valueOf('\u0000'));
        } else if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                result = Converts.toInteger(value, 0);
            } else if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                result = Converts.toLong(value, 0L);
            } else if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
                result = Converts.toByte(value, (byte)0);
            } else if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
                result = Converts.toShort(value, (short)0);
            } else if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
                result = Converts.toFloat(value, Float.valueOf(0.0f));
            } else if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
                result = Converts.toDouble(value, 0.0);
            } else if (BigDecimal.class.equals(clazz)) {
                result = Converts.toBigDecimal(value, new BigDecimal(0));
            }
        } else {
            result = clazz.cast(value);
        }
        return (T)result;
    }
}

