/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.utils;

import com.queryflow.common.DbType;
import com.queryflow.common.QueryFlowException;
import com.queryflow.log.Log;
import com.queryflow.log.LogFactory;
import com.queryflow.utils.Assert;
import com.queryflow.utils.Utils;
import java.lang.constant.Constable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;

public final class JdbcUtil {
    private static final Log log = LogFactory.getLog("queryflow");
    private static final boolean getObjectWithTypeAvailable = Utils.getMethod(ResultSet.class, "getObject", Integer.TYPE, Class.class) != null;

    private JdbcUtil() {
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error("close database connection error", e);
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.error("close database sql error", e);
            }
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error("close database ResultSet error", e);
            }
        }
    }

    public static void close(ResultSet rs, Statement statement) {
        JdbcUtil.close(rs);
        JdbcUtil.close(statement);
    }

    public static boolean supportBatch(Connection conn) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null) {
                if (metaData.supportsBatchUpdates()) {
                    log.info("JDBC driver supports batchUpdate updates");
                    return true;
                }
                log.error("JDBC driver does not support batchUpdate updates");
            }
        }
        catch (SQLException e) {
            log.error(e);
        }
        return false;
    }

    public static DbType getDbType(String jdbcUrl) {
        Assert.notEmpty(jdbcUrl);
        if (jdbcUrl.startsWith("jdbc:derby:") || jdbcUrl.startsWith("jdbc:log4jdbc:derby:")) {
            return DbType.DERBY;
        }
        if (jdbcUrl.startsWith("jdbc:mysql:") || jdbcUrl.startsWith("jdbc:cobar:") || jdbcUrl.startsWith("jdbc:log4jdbc:mysql:")) {
            return DbType.MYSQL;
        }
        if (jdbcUrl.startsWith("jdbc:oracle:") || jdbcUrl.startsWith("jdbc:log4jdbc:oracle:")) {
            return DbType.ORACLE;
        }
        if (jdbcUrl.startsWith("jdbc:microsoft:") || jdbcUrl.startsWith("jdbc:log4jdbc:microsoft:")) {
            return DbType.SQLSERVER;
        }
        if (jdbcUrl.startsWith("jdbc:sqlserver:") || jdbcUrl.startsWith("jdbc:log4jdbc:sqlserver:")) {
            return DbType.SQLSERVER;
        }
        if (jdbcUrl.startsWith("jdbc:postgresql:") || jdbcUrl.startsWith("jdbc:log4jdbc:postgresql:")) {
            return DbType.POSTGRESQL;
        }
        if (jdbcUrl.startsWith("jdbc:hsqldb:") || jdbcUrl.startsWith("jdbc:log4jdbc:hsqldb:")) {
            return DbType.HSQL;
        }
        if (jdbcUrl.startsWith("jdbc:db2:")) {
            return DbType.DB2;
        }
        if (jdbcUrl.startsWith("jdbc:sqlite:")) {
            return DbType.SQLITE;
        }
        if (jdbcUrl.startsWith("jdbc:h2:") || jdbcUrl.startsWith("jdbc:log4jdbc:h2:")) {
            return DbType.H2;
        }
        if (jdbcUrl.startsWith("jdbc:mariadb:")) {
            return DbType.MARIADB;
        }
        return DbType.OTHER;
    }

    public static DbType getDbType(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (connection == null) {
                throw new QueryFlowException("connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData metaData = connection.getMetaData();
            String jdbcUrl = metaData.getURL();
            DbType dbType = JdbcUtil.getDbType(jdbcUrl);
            return dbType;
        }
        catch (SQLException e) {
            throw new QueryFlowException(e);
        }
        finally {
            JdbcUtil.close(connection);
        }
    }

    public static boolean isJdbcCommonClass(Type type) {
        Assert.notNull(type);
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        return Utils.isPrimitiveOrWrapper(clazz) || String.class.equals((Object)clazz) || Date.class.equals((Object)clazz) || Timestamp.class.equals((Object)clazz) || java.util.Date.class.equals((Object)clazz) || Time.class.equals((Object)clazz) || BigDecimal.class.equals((Object)clazz) || Number.class.equals((Object)clazz) || byte[].class.equals((Object)clazz) || Blob.class.equals((Object)clazz) || Clob.class.equals((Object)clazz);
    }

    public static Object getResultSetValue(ResultSet rs, int index, Class<?> valueType) throws SQLException {
        Constable value;
        if (String.class.equals(valueType)) {
            return rs.getString(index);
        }
        if (Integer.TYPE.equals(valueType) || Integer.class.equals(valueType)) {
            value = rs.getInt(index);
        } else if (Short.TYPE.equals(valueType) || Short.class.equals(valueType)) {
            value = rs.getShort(index);
        } else if (Long.TYPE.equals(valueType) || Long.class.equals(valueType)) {
            value = rs.getLong(index);
        } else if (Byte.TYPE.equals(valueType) || Byte.class.equals(valueType)) {
            value = rs.getByte(index);
        } else if (Float.TYPE.equals(valueType) || Float.class.equals(valueType)) {
            value = Float.valueOf(rs.getFloat(index));
        } else if (Double.TYPE.equals(valueType) || Double.class.equals(valueType) || Number.class.equals(valueType)) {
            value = rs.getDouble(index);
        } else if (Boolean.TYPE.equals(valueType) || Boolean.class.equals(valueType)) {
            value = Boolean.valueOf(rs.getBoolean(index));
        } else {
            if (BigDecimal.class.equals(valueType)) {
                return rs.getBigDecimal(index);
            }
            if (Time.class.equals(valueType)) {
                return rs.getTime(index);
            }
            if (Date.class.equals(valueType)) {
                return rs.getDate(index);
            }
            if (Timestamp.class.equals(valueType) || java.util.Date.class.equals(valueType)) {
                return rs.getTimestamp(index);
            }
            if (byte[].class.equals(valueType)) {
                return rs.getBytes(index);
            }
            if (Blob.class.equals(valueType)) {
                return rs.getBlob(index);
            }
            if (Clob.class.equals(valueType)) {
                return rs.getClob(index);
            }
            if (getObjectWithTypeAvailable) {
                try {
                    return rs.getObject(index, valueType);
                }
                catch (AbstractMethodError err) {
                    log.debug("JDBC driver does not implement JDBC 4.1 'getObject(int, Class)' method", err);
                }
                catch (SQLFeatureNotSupportedException ex) {
                    log.debug("JDBC driver does not support JDBC 4.1 'getObject(int, Class)' method", ex);
                }
                catch (SQLException ex) {
                    log.debug("JDBC driver has limited support for JDBC 4.1 'getObject(int, Class)' method", ex);
                }
            }
            return JdbcUtil.getResultSetValue(rs, index);
        }
        return rs.wasNull() ? null : value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object value = rs.getObject(index);
        String className = null;
        if (value != null) {
            className = value.getClass().getName();
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            value = blob.getBytes(1L, (int)blob.length());
        } else if (value instanceof Clob) {
            Clob clob = (Clob)value;
            value = clob.getSubString(1L, (int)clob.length());
        } else if ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className)) {
            value = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String columnClassName = rs.getMetaData().getColumnClassName(index);
            value = "java.sql.Timestamp".equals(columnClassName) || "oracle.sql.TIMESTAMP".equals(columnClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (value instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            value = rs.getTimestamp(index);
        }
        return value;
    }

    public static String getColumnName(ResultSetMetaData metaData, int index) throws SQLException {
        String columnName = metaData.getColumnLabel(index);
        if (Utils.isEmpty(columnName)) {
            columnName = metaData.getColumnName(index);
        }
        return columnName;
    }
}

