/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.utils;

import com.queryflow.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlInterpolation {
    private static final Pattern PATTERN = Pattern.compile("(\\\\?\\?)");

    public String convert(String template, Object[] values) {
        List<Object> list = Arrays.asList(values);
        return this.convert(template, list);
    }

    public String convert(String template, List<Object> values) {
        if (Utils.isEmpty(template)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(template.length());
        Matcher matcher = PATTERN.matcher(template);
        int index = 0;
        while (matcher.find()) {
            String placeholder = matcher.group(1);
            if (placeholder.length() > 1 && placeholder.startsWith("\\")) continue;
            Object value = values.get(index);
            if (value != null) {
                if (value instanceof String) {
                    value = "'" + value + "'";
                }
                matcher.appendReplacement(sb, value.toString());
            } else {
                matcher.appendReplacement(sb, "null");
            }
            ++index;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

