/*
 * Decompiled with CFR 0.152.
 */
package com.queryflow.utils;

import com.queryflow.common.function.Action2;
import com.queryflow.utils.Assert;
import com.queryflow.utils.ClassInstantiationException;
import com.queryflow.utils.IORuntimeException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class Utils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap(8);

    private Utils() {
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || PRIMITIVE_WRAPPER_MAP.containsKey(clazz);
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isInterface()) {
            throw new ClassInstantiationException(clazz, "the class is interface.");
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ClassInstantiationException(clazz, "Is it an abstract class?", e);
        }
        catch (IllegalAccessException e) {
            throw new ClassInstantiationException(clazz, "Is the constructor accessible?", e);
        }
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (constructor != null) {
                if (Utils.canAccessPrivateMethod()) {
                    constructor.setAccessible(true);
                }
                if (constructor.isAccessible()) {
                    return constructor;
                }
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return null;
    }

    public static Method getterMethod(Field field) {
        Assert.notNull(field);
        Class<?> declaringClass = field.getDeclaringClass();
        Class<?> fieldType = field.getType();
        String methodName = Utils.capitalize(field.getName());
        methodName = fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class) ? "is" + methodName : "get" + methodName;
        Method method = Utils.getMethod(declaringClass, methodName, new Class[0]);
        if (method == null) {
            methodName = "" + methodName;
            method = Utils.getMethod(declaringClass, methodName, new Class[0]);
        }
        if (method != null && method.getReturnType().equals(fieldType)) {
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            return method;
        }
        return null;
    }

    public static Method setterMethod(Field field) {
        Assert.notNull(field);
        Class<?> declaringClass = field.getDeclaringClass();
        Class<?> fieldType = field.getType();
        String methodName = "set" + Utils.capitalize(field.getName());
        Method method = Utils.getMethod(declaringClass, methodName, fieldType);
        if (method != null) {
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            return method;
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null && (methods = clazz.getDeclaredMethods()).length > 0) {
            HashSet<Method> candidates = new HashSet<Method>(methods.length);
            for (Method expect : methods) {
                if (!methodName.equals(expect.getName())) continue;
                candidates.add(expect);
            }
            if (candidates.size() == 1) {
                method = (Method)candidates.iterator().next();
            } else if (candidates.size() > 1 && (paramTypes == null || paramTypes.length == 0)) {
                throw new IllegalStateException("No unique method found: " + clazz.getName() + '.' + methodName);
            }
        }
        return method;
    }

    public static Object[] toArray(Object value) {
        Object[] values;
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            values = (Object[])value;
        } else if (value instanceof List) {
            List list = (List)value;
            values = list.toArray();
        } else {
            values = new Object[]{value};
        }
        return values;
    }

    public static boolean isEmpty(String src) {
        return null == src || src.isEmpty();
    }

    public static boolean isNotEmpty(String src) {
        return !Utils.isEmpty(src);
    }

    public static boolean isBlank(String src) {
        if (Utils.isEmpty(src)) {
            return true;
        }
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(src.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String camelCaseToSnake(String src) {
        if (Utils.isEmpty(src)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(src.charAt(0));
        int len = src.length();
        for (int i = 1; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                result.append('_').append((char)(ch + 32));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static <T> String join(String separator, Collection<T> values, String suffix) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        int size = values.size();
        for (T value : values) {
            String str;
            if (value != null && !"".equals(str = value.toString())) {
                result.append(str);
                if (suffix != null) {
                    result.append(suffix);
                }
                if (i != size - 1) {
                    result.append(separator);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static <T> String join(String separator, Collection<T> values) {
        return Utils.join(separator, values, null);
    }

    public static void listFiles(File root, Action2<File, String> action2) {
        if (root != null && root.exists()) {
            if (root.isFile()) {
                if (action2 != null) {
                    action2.apply(root, "");
                }
            } else if (root.isDirectory()) {
                Utils.recursiveListFiles(root, "", action2);
            }
        }
    }

    public static void copy(InputStream in, OutputStream out) {
        byte[] buffer = new byte[1024];
        int len = 0;
        try {
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                Utils.close(in);
                throw throwable;
            }
        }
        Utils.close(in);
    }

    public static void close(Closeable ... closeables) {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        try {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Map<String, Object> propertiesToMap(Properties properties) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static void recursiveListFiles(File dir, String relativePath, Action2<File, String> action2) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            for (File file : files) {
                if (file.isFile()) {
                    if (action2 == null) continue;
                    action2.apply(file, relativePath);
                    continue;
                }
                if (!file.isDirectory()) continue;
                Utils.recursiveListFiles(file, relativePath + "/" + file.getName(), action2);
            }
        }
    }

    private static String capitalize(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    private static boolean canAccessPrivateMethod() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_MAP.put(Double.class, Double.TYPE);
    }
}

