/*
 * Decompiled with CFR 0.152.
 */
package com.github.jorgecastilloprz;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.jorgecastilloprz.completefab.CompleteFABListener;
import com.github.jorgecastilloprz.completefab.CompleteFABView;
import com.github.jorgecastilloprz.library.R;
import com.github.jorgecastilloprz.listeners.FABProgressListener;
import com.github.jorgecastilloprz.progressarc.ArcListener;
import com.github.jorgecastilloprz.progressarc.ProgressArcView;
import com.github.jorgecastilloprz.utils.LibraryUtils;

public class FABProgressCircle
extends FrameLayout
implements ArcListener,
CompleteFABListener {
    private final int SIZE_NORMAL = 1;
    private final int SIZE_MINI = 2;
    private int arcColor;
    private int arcWidth;
    private int circleSize;
    private boolean roundedStroke;
    private boolean reusable;
    private CompleteFABView completeFABView;
    private Drawable completeIconDrawable;
    private boolean viewsAdded;
    private ProgressArcView progressArc;
    private FABProgressListener listener;

    public FABProgressCircle(Context context) {
        super(context);
        this.init(null);
    }

    public FABProgressCircle(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public FABProgressCircle(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public FABProgressCircle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.setupInitialAttributes(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupInitialAttributes(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attrArray = this.getAttributes(attrs);
            try {
                this.arcColor = attrArray.getColor(R.styleable.FABProgressCircle_arcColor, this.getResources().getColor(R.color.fab_orange_dark));
                this.arcWidth = attrArray.getDimensionPixelSize(R.styleable.FABProgressCircle_arcWidth, this.getResources().getDimensionPixelSize(R.dimen.progress_arc_stroke_width));
                this.completeIconDrawable = attrArray.getDrawable(R.styleable.FABProgressCircle_finalIcon);
                this.circleSize = attrArray.getInt(R.styleable.FABProgressCircle_circleSize, 1);
                this.roundedStroke = attrArray.getBoolean(R.styleable.FABProgressCircle_roundedStroke, false);
                this.reusable = attrArray.getBoolean(R.styleable.FABProgressCircle_reusable, false);
            }
            finally {
                attrArray.recycle();
            }
        }
    }

    private TypedArray getAttributes(AttributeSet attrs) {
        return this.getContext().obtainStyledAttributes(attrs, R.styleable.FABProgressCircle, 0, 0);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.checkChildCount();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.viewsAdded) {
            this.addArcView();
            this.setupFab();
            this.viewsAdded = true;
        }
    }

    private void addArcView() {
        this.setClipChildren(false);
        this.progressArc = new ProgressArcView(this.getContext(), this.arcColor, this.arcWidth, this.roundedStroke);
        this.progressArc.setInternalListener(this);
        this.addView((View)this.progressArc, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.getFabDimension() + this.arcWidth, this.getFabDimension() + this.arcWidth, 17));
    }

    private void setupFab() {
        FrameLayout.LayoutParams fabParams = (FrameLayout.LayoutParams)this.getChildAt(0).getLayoutParams();
        fabParams.gravity = 17;
        if (LibraryUtils.isAFutureSimpleFAB(this.getChildAt(0))) {
            fabParams.topMargin = this.getResources().getDimensionPixelSize(R.dimen.futuresimple_fab_shadow_offset);
        }
    }

    private void checkChildCount() {
        if (this.getChildCount() != 1) {
            throw new IllegalStateException(this.getResources().getString(R.string.child_count_error));
        }
    }

    public void attachListener(FABProgressListener listener) {
        this.listener = listener;
    }

    public void show() {
        this.progressArc.show();
    }

    public void hide() {
        this.progressArc.stop();
    }

    public void beginFinalAnimation() {
        this.progressArc.requestCompleteAnimation();
    }

    @Override
    public void onArcAnimationComplete() {
        this.displayColorTransformAnimation();
    }

    private void displayColorTransformAnimation() {
        this.addCompleteFabView();
        ViewCompat.setElevation((View)this.completeFABView, (float)(ViewCompat.getElevation((View)this.getChildAt(0)) + 1.0f));
        this.completeFABView.animate(this.progressArc.getScaleDownAnimator());
    }

    private void addCompleteFabView() {
        this.completeFABView = new CompleteFABView(this.getContext(), this.completeIconDrawable, this.arcColor);
        this.completeFABView.attachListener(this);
        this.addView((View)this.completeFABView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.getFabDimension(), this.getFabDimension(), 17));
    }

    @Override
    public void onCompleteFABAnimationEnd() {
        this.doReusableReset();
        if (this.listener != null) {
            this.listener.onFABProgressAnimationEnd();
        }
    }

    private void doReusableReset() {
        if (this.isReusable()) {
            this.progressArc.reset();
            this.completeFABView.reset();
        }
    }

    private boolean isReusable() {
        return this.reusable;
    }

    private int getFabDimension() {
        if (this.circleSize == 1) {
            return this.getResources().getDimensionPixelSize(R.dimen.fab_size_normal);
        }
        return this.getResources().getDimensionPixelSize(R.dimen.fab_size_mini);
    }
}

