/*
 * Decompiled with CFR 0.152.
 */
package com.github.jorgecastilloprz.completefab;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.github.jorgecastilloprz.completefab.CompleteFABListener;
import com.github.jorgecastilloprz.library.R;

public class CompleteFABView
extends FrameLayout {
    private final int RESET_DELAY = 3000;
    private Drawable iconDrawable;
    private int arcColor;
    private CompleteFABListener listener;
    private boolean viewsAdded;

    public CompleteFABView(Context context, Drawable iconDrawable, int arcColor) {
        super(context);
        this.iconDrawable = iconDrawable;
        this.arcColor = arcColor;
        this.init();
    }

    public void attachListener(CompleteFABListener listener) {
        this.listener = listener;
    }

    private void init() {
        CompleteFABView.inflate((Context)this.getContext(), (int)R.layout.complete_fab, (ViewGroup)this);
    }

    private void tintCompleteFabWithArcColor() {
        Drawable background = this.getResources().getDrawable(R.drawable.oval_complete);
        background.setColorFilter(this.arcColor, PorterDuff.Mode.SRC_ATOP);
        this.findViewById(R.id.completeFabRoot).setBackgroundDrawable(background);
    }

    private void setIcon() {
        ImageView iconView = (ImageView)this.findViewById(R.id.completeFabIcon);
        iconView.setImageDrawable(this.iconDrawable != null ? this.iconDrawable : this.getResources().getDrawable(R.drawable.ic_done));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.viewsAdded) {
            this.setupContentSize();
            this.tintCompleteFabWithArcColor();
            this.setIcon();
            this.viewsAdded = true;
        }
    }

    private void setupContentSize() {
        int contentSize = (int)this.getResources().getDimension(R.dimen.fab_content_size);
        int mContentPadding = (this.getChildAt(0).getMeasuredWidth() - contentSize) / 2;
        this.getChildAt(0).setPadding(mContentPadding, mContentPadding, mContentPadding, mContentPadding);
    }

    public void animate(AnimatorSet progressArcAnimator) {
        this.animate(progressArcAnimator, false);
    }

    private void animate(AnimatorSet progressArcAnimator, boolean inverse) {
        ObjectAnimator completeFabAnim = ObjectAnimator.ofFloat((Object)this.getChildAt(0), (String)"alpha", (float[])new float[]{inverse ? 0.0f : 1.0f});
        completeFabAnim.setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        View icon = this.findViewById(R.id.completeFabIcon);
        ObjectAnimator iconScaleAnimX = ObjectAnimator.ofFloat((Object)icon, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator iconScaleAnimY = ObjectAnimator.ofFloat((Object)icon, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        LinearInterpolator iconAnimInterpolator = new LinearInterpolator();
        iconScaleAnimX.setDuration(250L).setInterpolator((TimeInterpolator)iconAnimInterpolator);
        iconScaleAnimY.setDuration(250L).setInterpolator((TimeInterpolator)iconAnimInterpolator);
        AnimatorSet animatorSet = new AnimatorSet();
        if (inverse) {
            animatorSet.playTogether(new Animator[]{completeFabAnim});
        } else {
            animatorSet.playTogether(new Animator[]{completeFabAnim, progressArcAnimator, iconScaleAnimX, iconScaleAnimY});
        }
        animatorSet.addListener(inverse ? this.getInverseAnimatorListener() : this.getAnimatorListener());
        if (inverse) {
            animatorSet.setStartDelay(3000L);
        }
        animatorSet.start();
    }

    private Animator.AnimatorListener getAnimatorListener() {
        return new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                CompleteFABView.this.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
                if (CompleteFABView.this.listener != null) {
                    CompleteFABView.this.listener.onCompleteFABAnimationEnd();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        };
    }

    private Animator.AnimatorListener getInverseAnimatorListener() {
        return new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                CompleteFABView.this.setVisibility(8);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        };
    }

    public void reset() {
        this.animate(null, true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }
}

