/*
 * Decompiled with CFR 0.152.
 */
package com.github.jorgecastilloprz.progressarc;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import com.github.jorgecastilloprz.progressarc.ArcListener;
import com.github.jorgecastilloprz.progressarc.animations.ArcAnimationFactory;
import com.github.jorgecastilloprz.utils.AnimationUtils;

final class ProgressArcDrawable
extends Drawable
implements Animatable {
    private final RectF arcBounds = new RectF();
    private float currentSweepAngle;
    private float currentRotationAngleOffset;
    private float currentRotationAngle;
    private ArcAnimationFactory animationFactory;
    private ValueAnimator rotateAnim;
    private ValueAnimator growAnim;
    private ValueAnimator shrinkAnim;
    private ValueAnimator completeAnim;
    private boolean animationPlaying;
    private boolean growing;
    private boolean completeAnimOnNextCycle;
    private Paint paint;
    private float strokeWidth;
    private int arcColor;
    private int minSweepAngle;
    private int maxSweepAngle;
    private ArcListener internalListener;

    ProgressArcDrawable(float strokeWidth, int arcColor, boolean roundedStroke) {
        this.strokeWidth = strokeWidth;
        this.arcColor = arcColor;
        this.initPaint(roundedStroke);
        this.setupAnimations();
    }

    private void initPaint(boolean roundedStroke) {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.strokeWidth);
        this.paint.setStrokeCap(roundedStroke ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.paint.setColor(this.arcColor);
    }

    private void setupAnimations() {
        this.animationFactory = new ArcAnimationFactory();
        this.minSweepAngle = 20;
        this.maxSweepAngle = 300;
        this.setupRotateAnimation();
        this.setupGrowAnimation();
        this.setupShrinkAnimation();
        this.setupCompleteAnimation();
    }

    private void setupRotateAnimation() {
        this.rotateAnim = this.animationFactory.buildAnimation(ArcAnimationFactory.Type.ROTATE, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float angle = AnimationUtils.getAnimatedFraction(animation) * 360.0f;
                ProgressArcDrawable.this.updateCurrentRotationAngle(angle);
            }
        }, null);
    }

    private void setupGrowAnimation() {
        this.growAnim = this.animationFactory.buildAnimation(ArcAnimationFactory.Type.GROW, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedFraction = AnimationUtils.getAnimatedFraction(animation);
                float angle = (float)ProgressArcDrawable.this.minSweepAngle + animatedFraction * (float)(ProgressArcDrawable.this.maxSweepAngle - ProgressArcDrawable.this.minSweepAngle);
                ProgressArcDrawable.this.updateCurrentSweepAngle(angle);
            }
        }, new Animator.AnimatorListener(){
            boolean cancelled = false;

            public void onAnimationStart(Animator animation) {
                this.cancelled = false;
                ProgressArcDrawable.this.growing = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.cancelled) {
                    ProgressArcDrawable.this.setShrinking();
                    ProgressArcDrawable.this.shrinkAnim.start();
                }
            }

            public void onAnimationCancel(Animator animation) {
                this.cancelled = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void setupShrinkAnimation() {
        this.shrinkAnim = this.animationFactory.buildAnimation(ArcAnimationFactory.Type.SHRINK, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedFraction = AnimationUtils.getAnimatedFraction(animation);
                ProgressArcDrawable.this.updateCurrentSweepAngle((float)ProgressArcDrawable.this.maxSweepAngle - animatedFraction * (float)(ProgressArcDrawable.this.maxSweepAngle - ProgressArcDrawable.this.minSweepAngle));
            }
        }, new Animator.AnimatorListener(){
            boolean cancelled;

            public void onAnimationStart(Animator animation) {
                this.cancelled = false;
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.cancelled) {
                    ProgressArcDrawable.this.setGrowing();
                    if (ProgressArcDrawable.this.completeAnimOnNextCycle) {
                        ProgressArcDrawable.this.completeAnimOnNextCycle = false;
                        ProgressArcDrawable.this.completeAnim.start();
                    } else {
                        ProgressArcDrawable.this.growAnim.start();
                    }
                }
            }

            public void onAnimationCancel(Animator animation) {
                this.cancelled = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void setupCompleteAnimation() {
        this.completeAnim = this.animationFactory.buildAnimation(ArcAnimationFactory.Type.COMPLETE, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedFraction = AnimationUtils.getAnimatedFraction(animation);
                float angle = (float)ProgressArcDrawable.this.minSweepAngle + animatedFraction * 360.0f;
                ProgressArcDrawable.this.updateCurrentSweepAngle(angle);
            }
        }, new Animator.AnimatorListener(){
            boolean cancelled = false;

            public void onAnimationStart(Animator animation) {
                this.cancelled = false;
                ProgressArcDrawable.this.growing = true;
                ProgressArcDrawable.this.rotateAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                ProgressArcDrawable.this.rotateAnim.setDuration(12000L);
            }

            public void onAnimationEnd(Animator animation) {
                if (!this.cancelled) {
                    ProgressArcDrawable.this.stop();
                }
                ProgressArcDrawable.this.completeAnim.removeListener((Animator.AnimatorListener)this);
                ProgressArcDrawable.this.internalListener.onArcAnimationComplete();
            }

            public void onAnimationCancel(Animator animation) {
                this.cancelled = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void draw(Canvas canvas) {
        float startAngle = this.currentRotationAngle - this.currentRotationAngleOffset;
        float sweepAngle = this.currentSweepAngle;
        if (!this.growing) {
            startAngle += 360.0f - sweepAngle;
        }
        canvas.drawArc(this.arcBounds, startAngle, sweepAngle, false, this.paint);
    }

    public void reset() {
        this.stop();
        this.resetProperties();
        this.setupAnimations();
        this.start();
    }

    private void resetProperties() {
        this.currentSweepAngle = 0.0f;
        this.currentRotationAngle = 0.0f;
        this.currentRotationAngleOffset = 0.0f;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.arcBounds.left = bounds.left;
        this.arcBounds.right = bounds.right;
        this.arcBounds.top = bounds.top;
        this.arcBounds.bottom = bounds.bottom;
    }

    private void setGrowing() {
        this.growing = true;
        this.currentRotationAngleOffset += (float)this.minSweepAngle;
    }

    private void setShrinking() {
        this.growing = false;
        this.currentRotationAngleOffset += (float)(360 - this.maxSweepAngle);
    }

    public void start() {
        this.animationPlaying = true;
        this.resetProperties();
        this.rotateAnim.start();
        this.growAnim.start();
        this.invalidateSelf();
    }

    public void stop() {
        this.animationPlaying = false;
        this.stopAnimators();
        this.invalidateSelf();
    }

    private void stopAnimators() {
        this.rotateAnim.cancel();
        this.growAnim.cancel();
        this.shrinkAnim.cancel();
        this.completeAnim.cancel();
    }

    void requestCompleteAnimation(ArcListener internalListener) {
        if (!this.isRunning() || this.completeAnim.isRunning()) {
            return;
        }
        this.internalListener = internalListener;
        this.startCompleteAnimationOnNextCycle();
    }

    private void startCompleteAnimationOnNextCycle() {
        this.completeAnimOnNextCycle = true;
    }

    void updateCurrentRotationAngle(float currentRotationAngle) {
        this.currentRotationAngle = currentRotationAngle;
        this.invalidateSelf();
    }

    void updateCurrentSweepAngle(float currentSweepAngle) {
        this.currentSweepAngle = currentSweepAngle;
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.animationPlaying;
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return 4;
    }
}

