/*
 * Decompiled with CFR 0.152.
 */
package com.github.jorgecastilloprz.progressarc;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.animation.DecelerateInterpolator;
import android.widget.ProgressBar;
import com.github.jorgecastilloprz.progressarc.ArcListener;
import com.github.jorgecastilloprz.progressarc.ProgressArcDrawable;

public final class ProgressArcView
extends ProgressBar {
    private ArcListener internalListener;
    private int arcColor;
    private int arcWidth;
    private boolean roundedStroke;

    public ProgressArcView(Context context, int arcColor, int arcWidth, boolean roundedStroke) {
        super(context);
        this.arcColor = arcColor;
        this.arcWidth = arcWidth;
        this.roundedStroke = roundedStroke;
        this.init(arcColor, arcWidth, roundedStroke);
    }

    public void init(int arcColor, int arcWidth, boolean roundedStroke) {
        this.setupInitialAlpha();
        ProgressArcDrawable arcDrawable = new ProgressArcDrawable(arcWidth, arcColor, roundedStroke);
        this.setIndeterminateDrawable(arcDrawable);
    }

    private void setupInitialAlpha() {
        this.setAlpha(0.0f);
    }

    public void setInternalListener(ArcListener internalListener) {
        this.internalListener = internalListener;
    }

    public void show() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ProgressArcView.this.setAlpha(1.0f);
                ProgressArcView.this.getDrawable().reset();
            }
        }, 150L);
    }

    public void stop() {
        this.getDrawable().stop();
        ObjectAnimator fadeOutAnim = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        fadeOutAnim.setDuration(100L).start();
    }

    public void reset() {
        this.getDrawable().reset();
        ObjectAnimator arcScaleX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.0f});
        ObjectAnimator arcScaleY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(0L).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        set.playTogether(new Animator[]{arcScaleX, arcScaleY});
        set.start();
    }

    public void requestCompleteAnimation() {
        this.getDrawable().requestCompleteAnimation(this.internalListener);
    }

    private ProgressArcDrawable getDrawable() {
        Drawable ret = this.getIndeterminateDrawable();
        return (ProgressArcDrawable)ret;
    }

    public AnimatorSet getScaleDownAnimator() {
        float scalePercent = (float)this.getWidth() / (float)(this.getWidth() + this.arcWidth + 5);
        ObjectAnimator arcScaleX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{scalePercent});
        ObjectAnimator arcScaleY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{scalePercent});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(150L).setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        set.playTogether(new Animator[]{arcScaleX, arcScaleY});
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                ProgressArcView.this.setupInitialAlpha();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        return set;
    }
}

