/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.guice;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ReflectionUtils;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedConfigParametersModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(NamedConfigParametersModule.class);
    private final Set<Object> beans;
    private final boolean registerBeans;

    public NamedConfigParametersModule(Collection beans, boolean registerBeans) {
        this.beans = new HashSet<Object>(beans);
        this.registerBeans = registerBeans;
    }

    public NamedConfigParametersModule(Collection beans) {
        this(beans, true);
    }

    protected void configure() {
        if (this.registerBeans) {
            this.registerBeanInstances();
        }
        for (Object bean : this.beans) {
            this.registerParameters(bean);
        }
    }

    private void registerParameters(Object bean) {
        Field[] fields;
        for (Field field : fields = ReflectionUtils.getAllFields(bean.getClass())) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter != null) {
                try {
                    TypeLiteral typeLiteral = TypeLiteral.get((Type)field.getGenericType());
                    Object value = ReflectionUtils.getFieldValue(bean, field);
                    if (value == null) {
                        this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)parameter.value())).toProvider(Providers.of(null));
                        continue;
                    }
                    this.bind(typeLiteral).annotatedWith((Annotation)Names.named((String)parameter.value())).toInstance(value);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("Couldn't bind \"" + field.getName() + "\"", (Throwable)e);
                }
                continue;
            }
            LOG.debug("Skipping field {}", (Object)field.getName());
        }
    }

    private void registerBeanInstances() {
        for (Object bean : this.beans) {
            TypeLiteral typeLiteral = TypeLiteral.get(bean.getClass());
            this.bind(typeLiteral).toInstance(bean);
        }
    }
}

