/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Days;

public class DaysConverter
implements Converter<Days> {
    @Override
    public Days convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Days.parseDays((String)trimmed);
            }
            int days = Integer.parseInt(trimmed);
            return Days.days((int)days);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Days.", ex);
        }
    }

    @Override
    public String convertTo(Days value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getDays());
    }
}

