/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.repositories;

import com.github.joschi.jadconfig.Repository;
import com.github.joschi.jadconfig.RepositoryException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;

public class PropertiesRepository
implements Repository {
    private final Properties PROPERTIES = new Properties();
    private File propertiesFile = null;

    public PropertiesRepository(String filename) {
        if (filename == null || "".equals(filename)) {
            throw new IllegalArgumentException("Properties filename must not be null or empty!");
        }
        this.propertiesFile = new File(filename);
    }

    public PropertiesRepository(File propertiesFile) {
        if (propertiesFile == null) {
            throw new IllegalArgumentException("Properties file must not be null!");
        }
        this.propertiesFile = propertiesFile;
    }

    @Override
    public void open() throws RepositoryException {
        if (this.propertiesFile == null) {
            throw new RepositoryException("Properties file must not be null!");
        }
        if (!this.propertiesFile.exists()) {
            throw new RepositoryException("Properties file " + this.propertiesFile.getPath() + " doesn't exist!");
        }
        FileReader propertiesReader = null;
        try {
            propertiesReader = new FileReader(this.propertiesFile);
            this.PROPERTIES.load(propertiesReader);
        }
        catch (IOException ex) {
            throw new RepositoryException("Couldn't open properties file: " + this.propertiesFile, ex);
        }
        finally {
            if (propertiesReader != null) {
                try {
                    ((Reader)propertiesReader).close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String read(String name) {
        return this.PROPERTIES.getProperty(name);
    }

    @Override
    public void close() throws RepositoryException {
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }
}

