/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeReference<T>
implements Comparable<TypeReference<T>> {
    private final Type type;
    private volatile Constructor<?> constructor;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    public T newInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.constructor == null) {
            Class rawType = this.type instanceof Class ? (Class)this.type : (Class)((ParameterizedType)this.type).getRawType();
            this.constructor = rawType.getConstructor(new Class[0]);
        }
        return (T)this.constructor.newInstance(new Object[0]);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(TypeReference<T> obj) {
        return 0;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TypeReference && ((TypeReference)obj).type.equals(this.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "TypeReference{" + this.type.toString() + "}";
    }
}

