/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.jadconfig.jodatime.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import org.joda.time.Hours;

public class HoursConverter
implements Converter<Hours> {
    @Override
    public Hours convertFrom(String value) {
        try {
            String trimmed = value.trim();
            if (trimmed.startsWith("P")) {
                return Hours.parseHours((String)trimmed);
            }
            int hours = Integer.parseInt(trimmed);
            return Hours.hours((int)hours);
        }
        catch (Exception ex) {
            throw new ParameterException("Couldn't convert value \"" + value + "\" to Hours.", ex);
        }
    }

    @Override
    public String convertTo(Hours value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert \"null\" to String.");
        }
        return String.valueOf(value.getHours());
    }
}

