/*
 * Decompiled with CFR 0.152.
 */
package org.libsodium.jni.keys;

import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.crypto.Random;
import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;
import org.libsodium.jni.keys.VerifyKey;

@Deprecated
public class SigningKey {
    private final byte[] seed;
    private final byte[] secretKey;
    private VerifyKey verifyKey;

    public SigningKey(byte[] seed) {
        Util.checkLength(seed, 32);
        this.seed = seed;
        this.secretKey = Util.zeros(64);
        byte[] publicKey = Util.zeros(32);
        NaCl.sodium();
        Util.isValid(Sodium.crypto_sign_ed25519_seed_keypair(publicKey, this.secretKey, seed), "Failed to generate a key pair");
        this.verifyKey = new VerifyKey(publicKey);
    }

    public SigningKey() {
        this(new Random().randomBytes(32));
    }

    public SigningKey(String seed, Encoder encoder) {
        this(encoder.decode(seed));
    }

    public VerifyKey getVerifyKey() {
        return this.verifyKey;
    }

    public byte[] sign(byte[] message) {
        byte[] signature = Util.prependZeros(64, message);
        int[] bufferLen = new int[1];
        NaCl.sodium();
        Sodium.crypto_sign_ed25519(signature, bufferLen, message, message.length, this.secretKey);
        signature = Util.slice(signature, 0, 64);
        return signature;
    }

    public String sign(String message, Encoder encoder) {
        byte[] signature = this.sign(encoder.decode(message));
        return encoder.encode(signature);
    }

    public byte[] toBytes() {
        return this.seed;
    }

    public String toString() {
        return Encoder.HEX.encode(this.seed);
    }
}

