/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.TesterException;
import java.util.Arrays;

final class Assert {
    public static boolean assertEquals(Object expected, Object actual) {
        return Assert.assertEquals(expected, actual, null);
    }

    public static boolean assertEquals(Object expected, Object actual, String message) {
        if (!Assert.objectsAreEqual(expected, actual)) {
            Assert.failNotEqual(expected, actual, message);
            return false;
        }
        return true;
    }

    public static boolean assertNotNull(Object actual) {
        return Assert.assertNotNull(actual, null);
    }

    public static boolean assertNotNull(Object actual, String message) {
        if (actual == null) {
            Assert.failNull(message);
            return false;
        }
        return true;
    }

    private static void failNull(String message) {
        Assert.fail(Assert.buildPrefix(message) + "expected: not <null>");
    }

    private static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static void failNotEqual(Object expected, Object actual, String message) {
        Assert.fail(Assert.format(expected, actual, message));
    }

    private static String format(Object expected, Object actual, String message) {
        return Assert.buildPrefix(message) + Assert.formatValues(expected, actual);
    }

    private static String buildPrefix(String message) {
        return Assert.isNotBlank(message) ? message + " ==> " : "";
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    private static boolean isNotBlank(String str) {
        return !Assert.isBlank(str);
    }

    private static String formatValues(Object expected, Object actual) {
        String actualString;
        String expectedString = Assert.toString(expected);
        return expectedString.equals(actualString = Assert.toString(actual)) ? String.format("expected: %s but was: %s", Assert.formatClassAndValue(expected, expectedString), Assert.formatClassAndValue(actual, actualString)) : String.format("expected: <%s> but was: <%s>", expectedString, actualString);
    }

    private static String formatClassAndValue(Object value, String valueString) {
        if (value == null) {
            return "<null>";
        }
        String classAndHash = Assert.getClassName(value) + Assert.toHash(value);
        return value instanceof Class ? "<" + classAndHash + ">" : classAndHash + "<" + valueString + ">";
    }

    private static String toString(Object obj) {
        return obj instanceof Class ? Assert.getCanonicalName((Class)obj) : Assert.nullSafeToString(obj);
    }

    private static String toHash(Object obj) {
        return obj == null ? "" : "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getClassName(Object obj) {
        return obj == null ? "null" : (obj instanceof Class ? Assert.getCanonicalName((Class)obj) : obj.getClass().getName());
    }

    private static String getCanonicalName(Class<?> clazz) {
        try {
            String canonicalName = clazz.getCanonicalName();
            return canonicalName != null ? canonicalName : clazz.getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return clazz.getName();
        }
    }

    private static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            if (obj.getClass().isArray()) {
                if (obj.getClass().getComponentType().isPrimitive()) {
                    if (obj instanceof boolean[]) {
                        return Arrays.toString((boolean[])obj);
                    }
                    if (obj instanceof char[]) {
                        return Arrays.toString((char[])obj);
                    }
                    if (obj instanceof short[]) {
                        return Arrays.toString((short[])obj);
                    }
                    if (obj instanceof byte[]) {
                        return Arrays.toString((byte[])obj);
                    }
                    if (obj instanceof int[]) {
                        return Arrays.toString((int[])obj);
                    }
                    if (obj instanceof long[]) {
                        return Arrays.toString((long[])obj);
                    }
                    if (obj instanceof float[]) {
                        return Arrays.toString((float[])obj);
                    }
                    if (obj instanceof double[]) {
                        return Arrays.toString((double[])obj);
                    }
                }
                return Arrays.deepToString((Object[])obj);
            }
            String result = obj.toString();
            return result != null ? result : "null";
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Assert.defaultToString(obj);
        }
    }

    private static String defaultToString(Object obj) {
        return obj == null ? "null" : obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static void fail(String message) {
        throw new TesterException(message);
    }

    private Assert() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

