/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.Assert;
import com.joutvhu.model.tester.Creator;
import com.joutvhu.model.tester.Tester;

class ConstructorTester<T>
implements Tester {
    private Creator<T> creatable;

    ConstructorTester(Creator<T> creatable) {
        this.creatable = creatable;
    }

    @Override
    public boolean test() {
        try {
            T result = this.creatable.create();
            boolean success = Assert.assertNotNull(result);
            if (success) {
                System.out.println("Success: " + this.creatable.modelClass.getName() + "(" + this.params() + ")");
            } else {
                System.err.println("Failure: " + this.creatable.modelClass.getName() + "(" + this.params() + ")");
            }
            return success;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.creatable.modelClass.getName() + "(" + this.params() + ")");
            e.printStackTrace();
            return false;
        }
    }

    private String params() {
        boolean comma = false;
        StringBuilder builder = new StringBuilder();
        if (this.creatable.values != null) {
            for (Object value : this.creatable.values) {
                if (comma) {
                    builder.append(",");
                }
                builder.append(value.getClass().getName());
                comma = true;
            }
        }
        if (this.creatable.parameters != null) {
            for (Creator creator : this.creatable.parameters) {
                if (comma) {
                    builder.append(",");
                }
                builder.append(creator.modelClass.getName());
                comma = true;
            }
        }
        return builder.toString();
    }
}

