/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javassist.util.proxy.ProxyFactory;

public class Creator<T> {
    final Class<T> modelClass;
    final List<Creator<?>> parameters;
    final Object[] values;
    final T staticValue;

    private Creator(Class<T> modelClass, List<Creator<?>> parameters, T staticValue, Object[] values) {
        this.modelClass = modelClass;
        this.parameters = parameters;
        this.staticValue = staticValue;
        this.values = values;
    }

    public static <T> Creator<T> of(Constructor<T> constructor) {
        ArrayList parameters = new ArrayList();
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            parameters.add(Creator.anyOf(parameterType));
        }
        return new Creator<Object>(constructor.getDeclaringClass(), parameters, null, null);
    }

    public static <T> Creator<T> of(Class<T> modelClass, Creator<?> ... parameters) {
        return new Creator<Object>(modelClass, Arrays.asList(parameters), null, null);
    }

    public static <T> Creator<T> byParams(Class<T> modelClass, Object ... parameters) {
        return new Creator<Object>(modelClass, null, null, parameters);
    }

    public static <T> Creator<T> anyOf(Class<T> modelClass) {
        T result = Creator.tryMakeProxy(modelClass);
        if (result != null) {
            return new Creator<T>(modelClass, null, result, null);
        }
        Constructor<?>[] constructors = modelClass.getConstructors();
        if (constructors.length == 0) {
            constructors = modelClass.getDeclaredConstructors();
        }
        if (constructors.length > 0) {
            Constructor<?> constructor = constructors[0];
            for (Constructor<?> c : constructors) {
                if (c.getParameterCount() >= constructor.getParameterCount()) continue;
                constructor = c;
            }
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Creator[] parameters = new Creator[parameterTypes.length];
            int len = parameterTypes.length;
            for (int i = 0; i < len; ++i) {
                parameters[i] = Creator.anyOf(parameterTypes[i]);
            }
            return Creator.of(modelClass, parameters);
        }
        return new Creator<Object>(modelClass, new ArrayList(), null, null);
    }

    public static <T> Creator<T>[] allOf(Class<T> modelClass) {
        ArrayList creators = new ArrayList();
        if (modelClass.isEnum()) {
            Object[] values;
            for (Object value : values = EnumSet.allOf(modelClass).toArray()) {
                creators.add(new Creator<Object>(modelClass, null, value, null));
            }
        } else {
            HashSet created = new HashSet();
            for (Constructor<?> constructor : modelClass.getConstructors()) {
                if (created.contains(constructor)) continue;
                created.add(constructor);
                creators.add(Creator.of(constructor));
            }
            for (Constructor<?> constructor : modelClass.getDeclaredConstructors()) {
                if (created.contains(constructor)) continue;
                created.add(constructor);
                creators.add(Creator.of(constructor));
            }
        }
        return creators.toArray(new Creator[creators.size()]);
    }

    public T create() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (this.staticValue != null) {
            return this.staticValue;
        }
        T result = Creator.makeProxy(this.modelClass);
        if (result != null) {
            return result;
        }
        int mod = this.modelClass.getModifiers();
        if (Modifier.isInterface(mod)) {
            return this.interfaceProxy(this.modelClass);
        }
        if (Modifier.isAbstract(mod)) {
            return this.abstractProxy(this.modelClass);
        }
        if (this.values != null) {
            return Creator.create(this.modelClass, this.values);
        }
        return Creator.create(this.modelClass, this.parameters);
    }

    private <T> T abstractProxy(Class<T> modelClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object[] parameterValues;
        Class[] parameterTypes;
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(modelClass);
        factory.setFilter(method -> Modifier.isAbstract(method.getModifiers()));
        if (this.values != null) {
            parameterTypes = new Class[this.values.length];
            parameterValues = this.values;
            int len = this.values.length;
            for (int i = 0; i < len; ++i) {
                parameterTypes[i] = this.values[i].getClass();
            }
        } else {
            int len;
            if (this.parameters != null) {
                parameterTypes = new Class[this.parameters.size()];
                len = this.parameters.size();
                for (int i = 0; i < len; ++i) {
                    parameterTypes[i] = this.parameters.get((int)i).modelClass;
                }
            } else {
                Constructor<?>[] constructors = modelClass.getConstructors();
                if (constructors.length == 0) {
                    constructors = modelClass.getDeclaredConstructors();
                }
                parameterTypes = constructors.length > 0 ? constructors[0].getParameterTypes() : new Class[]{};
            }
            parameterValues = new Object[parameterTypes.length];
            len = parameterTypes.length;
            for (int i = 0; i < len; ++i) {
                try {
                    parameterValues[i] = Creator.anyOf(parameterTypes[i]).create();
                    continue;
                }
                catch (Throwable e) {
                    if (Creator.isNullable(parameterTypes[i])) {
                        parameterValues[i] = null;
                        continue;
                    }
                    throw e;
                }
            }
        }
        return (T)factory.create(parameterTypes, parameterValues, (self, thisMethod, proceed, args) -> {
            if (!Void.class.equals(thisMethod.getReturnType())) {
                try {
                    return Creator.anyOf(thisMethod.getReturnType()).create();
                }
                catch (Throwable x) {
                    return null;
                }
            }
            return null;
        });
    }

    private <T> T interfaceProxy(Class<T> modelClass) {
        return (T)Proxy.newProxyInstance(modelClass.getClassLoader(), new Class[]{modelClass}, (proxy, method, args) -> {
            if (!Void.class.equals(method.getReturnType())) {
                try {
                    return Creator.anyOf(method.getReturnType()).create();
                }
                catch (Throwable x) {
                    return null;
                }
            }
            return null;
        });
    }

    public static <T> T create(Class<T> modelClass, List<Creator<?>> parameters) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class[] parameterTypes = new Class[parameters.size()];
        Object[] params = new Object[parameters.size()];
        int len = parameters.size();
        for (int i = 0; i < len; ++i) {
            parameterTypes[i] = parameters.get((int)i).modelClass;
            try {
                params[i] = parameters.get(i).create();
                continue;
            }
            catch (Throwable e) {
                if (Creator.isNullable(parameters.get((int)i).modelClass)) {
                    params[i] = null;
                    continue;
                }
                throw e;
            }
        }
        Constructor<T> constructor = modelClass.getConstructor(parameterTypes);
        return constructor.newInstance(params);
    }

    public static <T> T create(Class<T> modelClass, Object ... params) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class[] paramClasses = new Class[params.length];
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            Object param = params[i];
            paramClasses[i] = param.getClass();
        }
        Constructor<T> constructor = modelClass.getConstructor(paramClasses);
        return constructor.newInstance(params);
    }

    private static <T> T tryMakeProxy(Class<T> modelClass) {
        try {
            return Creator.makeProxy(modelClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T makeCopy(T value) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        if (value == null) {
            return null;
        }
        Class<?> modelClass = value.getClass();
        if (String.class.equals(modelClass) || Boolean.class.equals(modelClass) || modelClass == Boolean.TYPE || Integer.class.equals(modelClass) || modelClass == Integer.TYPE || Long.class.equals(modelClass) || modelClass == Long.TYPE || Float.class.equals(modelClass) || modelClass == Float.TYPE || Double.class.equals(modelClass) || modelClass == Double.TYPE || Character.class.equals(modelClass) || modelClass == Character.TYPE || Byte.class.equals(modelClass) || modelClass == Byte.TYPE || Short.class.equals(modelClass) || modelClass == Short.TYPE || BigInteger.class.equals(modelClass) || BigDecimal.class.equals(modelClass) || modelClass.isEnum()) {
            return value;
        }
        Object newValue = Creator.anyOf(modelClass).create();
        if (value instanceof Map) {
            ((Map)newValue).putAll((Map)value);
        } else if (value instanceof Collection) {
            ((Collection)newValue).addAll((Collection)value);
        } else if (newValue != null) {
            Class<?> clazz = modelClass;
            do {
                Creator.copyFields(modelClass.getDeclaredFields(), value, newValue);
                Creator.copyFields(modelClass.getFields(), value, newValue);
            } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        }
        return (T)newValue;
    }

    private static void copyFields(Field[] fields, Object v1, Object v2) throws IllegalAccessException {
        for (Field field : fields) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            field.set(v2, field.get(v1));
        }
    }

    public static boolean isNullable(Class<?> modelClass) {
        return modelClass != Boolean.TYPE && modelClass != Integer.TYPE && modelClass != Long.TYPE && modelClass != Float.TYPE && modelClass != Double.TYPE && modelClass != Character.TYPE && modelClass != Byte.TYPE && modelClass != Short.TYPE;
    }

    private static <T> T makeProxy(Class<T> modelClass) {
        if (String.class.equals(modelClass)) {
            return (T)"";
        }
        if (Boolean.class.equals(modelClass) || modelClass == Boolean.TYPE) {
            return (T)Boolean.TRUE;
        }
        if (Integer.class.equals(modelClass) || modelClass == Integer.TYPE) {
            return (T)Integer.valueOf(0);
        }
        if (Long.class.equals(modelClass) || modelClass == Long.TYPE) {
            return (T)Long.valueOf(0L);
        }
        if (Float.class.equals(modelClass) || modelClass == Float.TYPE) {
            return (T)Float.valueOf(0.0f);
        }
        if (Double.class.equals(modelClass) || modelClass == Double.TYPE) {
            return (T)Double.valueOf(0.0);
        }
        if (Character.class.equals(modelClass) || modelClass == Character.TYPE) {
            return (T)Character.valueOf('c');
        }
        if (Byte.class.equals(modelClass) || modelClass == Byte.TYPE) {
            return (T)Byte.valueOf((byte)0);
        }
        if (Short.class.equals(modelClass) || modelClass == Short.TYPE) {
            return (T)Short.valueOf((short)0);
        }
        if (BigInteger.class.equals(modelClass)) {
            return (T)BigInteger.valueOf(0L);
        }
        if (BigDecimal.class.equals(modelClass)) {
            return (T)BigDecimal.valueOf(0L);
        }
        if (modelClass.isArray()) {
            return (T)Array.newInstance(modelClass.getComponentType(), 0);
        }
        if (List.class.equals(modelClass) || Collection.class.equals(modelClass) || AbstractCollection.class.equals(modelClass) || AbstractList.class.equals(modelClass)) {
            return (T)new ArrayList();
        }
        if (Map.class.equals(modelClass) || AbstractMap.class.equals(modelClass)) {
            return (T)new HashMap();
        }
        if (Set.class.equals(modelClass) || AbstractSet.class.equals(modelClass)) {
            return (T)new HashSet();
        }
        if (SortedSet.class.equals(modelClass) || NavigableSet.class.equals(modelClass)) {
            return (T)new TreeSet();
        }
        if (Queue.class.equals(modelClass) || Deque.class.equals(modelClass) || AbstractSequentialList.class.equals(modelClass)) {
            return (T)new LinkedList();
        }
        if (SortedMap.class.equals(modelClass) || NavigableMap.class.equals(modelClass)) {
            return (T)new TreeMap();
        }
        if (Dictionary.class.equals(modelClass)) {
            return (T)new Hashtable();
        }
        if (Temporal.class.equals(modelClass) || Instant.class.equals(modelClass)) {
            return (T)Instant.now();
        }
        return Creator.makeEnum(modelClass);
    }

    private static <T> T makeEnum(Class<T> modelClass) {
        if (modelClass.isEnum()) {
            Object[] values = EnumSet.allOf(modelClass).toArray();
            return (T)values[0];
        }
        return null;
    }
}

