/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.Assert;
import com.joutvhu.model.tester.Creator;
import com.joutvhu.model.tester.Tester;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class EqualsTester<T>
implements Tester {
    private final Class<T> modelClass;
    private final boolean safe;

    EqualsTester(Class<T> modelClass) {
        this(modelClass, false);
    }

    EqualsTester(Class<T> modelClass, boolean safe) {
        this.modelClass = modelClass;
        this.safe = safe;
    }

    @Override
    public boolean test() {
        try {
            T model = Creator.anyOf(this.modelClass).create();
            boolean success = Assert.assertEquals(model, model);
            success = model != null && !model.equals(null) && success;
            try {
                T newModel = Creator.makeCopy(model);
                success = Assert.assertEquals(model, newModel) && success;
                this.deepTest(model, newModel);
            }
            catch (Throwable x) {
                if (this.safe) {
                    this.deepTest(model, null);
                }
                throw x;
            }
            if (success) {
                System.out.println("Success: " + this.modelClass.getName() + ".equals()");
            } else {
                System.err.println("Failure: " + this.modelClass.getName() + ".equals()");
            }
            return success;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + ".equals()");
            e.printStackTrace();
            return false;
        }
    }

    private void deepTest(T model, T newModel) {
        try {
            if (newModel == null) {
                newModel = Creator.makeCopy(model);
            }
            HashSet<Field> tested = new HashSet<Field>();
            this.deepTest(model, newModel, this.modelClass.getDeclaredFields(), tested);
            this.deepTest(model, newModel, this.modelClass.getFields(), tested);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void deepTest(T model, T newModel, Field[] fields, Set<Field> tested) {
        boolean restore = this.modelClass.isEnum();
        HashMap<Field, Object> backup = new HashMap<Field, Object>();
        for (Field field : fields) {
            try {
                if (restore) {
                    field.setAccessible(true);
                    backup.put(field, field.get(model));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (tested.contains(field) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                tested.add(field);
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                if (fieldType == Boolean.TYPE) {
                    field.set(newModel, false);
                } else if (fieldType == Integer.TYPE) {
                    field.set(newModel, 1);
                } else if (fieldType == Long.TYPE) {
                    field.set(newModel, 2L);
                } else if (fieldType == Float.TYPE) {
                    field.set(newModel, 1.1);
                } else if (fieldType == Double.TYPE) {
                    field.set(newModel, 1.2);
                } else if (fieldType == Character.TYPE) {
                    field.set(newModel, Character.valueOf('v'));
                } else if (fieldType == Byte.TYPE) {
                    field.set(newModel, (byte)10);
                } else if (fieldType == Short.TYPE) {
                    field.set(newModel, (byte)20);
                } else {
                    field.set(newModel, null);
                }
                Assert.assertEquals(model, newModel);
                field.set(newModel, field.get(model));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (restore && !backup.isEmpty()) {
            for (Map.Entry entry : backup.entrySet()) {
                try {
                    Field field = (Field)entry.getKey();
                    Object value = entry.getValue();
                    field.set(model, value);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

