/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.Assert;
import com.joutvhu.model.tester.Creator;
import com.joutvhu.model.tester.Tester;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class GetterSetterTester<T>
implements Tester {
    private Class<T> modelClass;
    private List<String> include;
    private List<String> exclude;

    GetterSetterTester(Class<T> modelClass, List<String> include, List<String> exclude) {
        this.modelClass = modelClass;
        this.include = include;
        this.exclude = exclude;
    }

    @Override
    public boolean test() {
        try {
            T model = Creator.anyOf(this.modelClass).create();
            if (model == null) {
                return false;
            }
            boolean success = true;
            HashSet<Method> tested = new HashSet<Method>();
            if (!this.testMethods(model, this.modelClass.getDeclaredMethods(), tested)) {
                success = false;
            }
            if (!this.testMethods(model, this.modelClass.getMethods(), tested)) {
                success = false;
            }
            return success;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean testMethods(T model, Method[] methods, Set<Method> tested) {
        boolean success = true;
        for (Method method : methods) {
            Field field;
            if (tested.contains(method)) continue;
            tested.add(method);
            if (this.isGetter(method)) {
                field = this.getField(method);
                if (!this.checkName(method, field)) continue;
                if (field != null && method.getReturnType().equals(field.getType()) && !Modifier.isFinal(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                    success = this.testGetter(model, method, field) && success;
                    continue;
                }
                success = this.testGetter(model, method) && success;
                continue;
            }
            if (!this.isSetter(method) || !this.checkName(method, field = this.getField(method))) continue;
            success = field != null && method.getParameterTypes()[0].equals(field.getType()) && !Modifier.isFinal(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) ? this.testSetter(model, method, field) && success : this.testSetter(model, method) && success;
        }
        return success;
    }

    private Object createTestValue(Class<?> fieldClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        try {
            return Creator.anyOf(fieldClass).create();
        }
        catch (Throwable e) {
            if (Creator.isNullable(fieldClass)) {
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testGetter(T model, Method method, Field field) {
        boolean restore = this.modelClass.isEnum();
        Object backup = null;
        try {
            field.setAccessible(true);
            backup = field.get(model);
        }
        catch (Throwable e) {
            restore = false;
        }
        try {
            Object value = this.createTestValue(field.getType());
            field.setAccessible(true);
            field.set(model, value);
            method.setAccessible(true);
            Object result = method.invoke(model, new Object[0]);
            boolean success = Assert.assertEquals(value, result);
            if (success) {
                System.out.println("Success: " + this.modelClass.getName() + "." + method.getName() + "()");
            } else {
                System.err.println("Failure: " + this.modelClass.getName() + "." + method.getName() + "()");
            }
            boolean bl = success;
            return bl;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + "." + method.getName() + "()");
            e.printStackTrace();
        }
        finally {
            if (restore) {
                try {
                    field.setAccessible(true);
                    field.set(model, backup);
                }
                catch (Throwable throwable) {}
            }
        }
        return false;
    }

    private boolean testGetter(T model, Method method) {
        try {
            method.setAccessible(true);
            method.invoke(model, new Object[0]);
            System.out.println("Success: " + this.modelClass.getName() + "." + method.getName() + "()");
            return true;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + "." + method.getName() + "()");
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testSetter(T model, Method method, Field field) {
        boolean restore = this.modelClass.isEnum();
        Object backup = null;
        try {
            field.setAccessible(true);
            backup = field.get(model);
        }
        catch (Throwable e) {
            restore = false;
        }
        try {
            Object value = this.createTestValue(method.getParameterTypes()[0]);
            method.setAccessible(true);
            method.invoke(model, value);
            field.setAccessible(true);
            Object result = field.get(model);
            boolean success = Assert.assertEquals(value, result);
            if (success) {
                System.out.println("Success: " + this.modelClass.getName() + "." + method.getName() + "(" + method.getParameterTypes()[0].getName() + ")");
            } else {
                System.err.println("Failure: " + this.modelClass.getName() + "." + method.getName() + "(" + method.getParameterTypes()[0].getName() + ")");
            }
            boolean bl = success;
            return bl;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + "." + method.getName() + "(" + method.getParameterTypes()[0].getName() + ")");
            e.printStackTrace();
        }
        finally {
            if (restore) {
                try {
                    field.setAccessible(true);
                    field.set(model, backup);
                }
                catch (Throwable throwable) {}
            }
        }
        return false;
    }

    private boolean testSetter(T model, Method method) {
        try {
            Object value = this.createTestValue(method.getParameterTypes()[0]);
            method.setAccessible(true);
            method.invoke(model, value);
            System.out.println("Success: " + this.modelClass.getName() + "." + method.getName() + "(" + method.getParameterTypes()[0].getName() + ")");
            return true;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + "." + method.getName() + "(" + method.getParameterTypes()[0].getName() + ")");
            e.printStackTrace();
            return false;
        }
    }

    private Field getField(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        }
        Class<T> clazz = this.modelClass;
        do {
            Field field;
            if ((field = this.getField(methodName, clazz.getDeclaredFields())) != null) {
                return field;
            }
            field = this.getField(methodName, clazz.getFields());
            if (field == null) continue;
            return field;
        } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        return null;
    }

    private Field getField(String fieldName, Field[] fields) {
        for (Field field : fields) {
            if (!fieldName.equalsIgnoreCase(field.getName())) continue;
            return field;
        }
        return null;
    }

    private boolean isGetter(Method method) {
        String methodName = method.getName();
        if (methodName.length() > 3 && methodName.startsWith("get") && method.getParameterCount() == 0) {
            return true;
        }
        if (methodName.length() > 2 && methodName.startsWith("is") && method.getParameterCount() == 0) {
            Class<?> returnType = method.getReturnType();
            return Boolean.class.equals(returnType) || returnType == Boolean.TYPE;
        }
        return false;
    }

    private boolean isSetter(Method method) {
        String methodName = method.getName();
        return methodName.length() > 3 && methodName.startsWith("set") && method.getParameterCount() == 1;
    }

    private boolean checkName(Method method, Field field) {
        if (this.include != null && !this.include.isEmpty()) {
            return this.include.contains(method.getName()) || field != null && this.include.contains(field.getName());
        }
        if (this.exclude != null && !this.exclude.isEmpty()) {
            return !this.exclude.contains(method.getName()) && (field == null || !this.exclude.contains(field.getName()));
        }
        return true;
    }
}

