/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.Assert;
import com.joutvhu.model.tester.Creator;
import com.joutvhu.model.tester.Tester;

class HashCodeTester<T>
implements Tester {
    private final Class<T> modelClass;
    private final boolean safe;

    HashCodeTester(Class<T> modelClass) {
        this(modelClass, false);
    }

    HashCodeTester(Class<T> modelClass, boolean safe) {
        this.modelClass = modelClass;
        this.safe = safe;
    }

    @Override
    public boolean test() {
        try {
            T model = Creator.anyOf(this.modelClass).create();
            boolean success = true;
            if (this.safe) {
                success = Assert.assertEquals(model.hashCode(), model.hashCode());
            } else {
                T newModel = Creator.makeCopy(model);
                success = Assert.assertEquals(model.hashCode(), newModel.hashCode());
            }
            if (success) {
                System.out.println("Success: " + this.modelClass.getName() + ".hashCode()");
            } else {
                System.err.println("Failure: " + this.modelClass.getName() + ".hashCode()");
            }
            return success;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + ".hashCode()");
            e.printStackTrace();
            return false;
        }
    }
}

