/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.ConstructorTester;
import com.joutvhu.model.tester.Creator;
import com.joutvhu.model.tester.EqualsTester;
import com.joutvhu.model.tester.GetterSetterTester;
import com.joutvhu.model.tester.HashCodeTester;
import com.joutvhu.model.tester.Tester;
import com.joutvhu.model.tester.TesterException;
import com.joutvhu.model.tester.ToStringTester;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModelTester<T> {
    private final Class<T> modelClass;
    private final List<Tester> testers = new ArrayList<Tester>();

    public ModelTester(Class<T> modelClass) {
        int mod = modelClass.getModifiers();
        if (Modifier.isInterface(mod)) {
            throw new TesterException("Can't test an interface.");
        }
        this.modelClass = modelClass;
    }

    public static <T> ModelTester<T> of(Class<T> modelClass) {
        return new ModelTester<T>(modelClass);
    }

    public static <T> ModelTester<T> allOf(Class<T> modelClass) {
        return new ModelTester<T>(modelClass).constructors().getterSetters().equalsMethod().hashCodeMethod().toStringMethod();
    }

    public static <T> ModelTester<T> safeOf(Class<T> modelClass) {
        return new ModelTester<T>(modelClass).constructors().getterSetters().equalsSafe().hashCodeSafe().toStringSafe();
    }

    public ModelTester<T> constructors() {
        for (Creator<T> creatable : Creator.allOf(this.modelClass)) {
            this.testers.add(new ConstructorTester<T>(creatable));
        }
        return this;
    }

    public ModelTester<T> constructor(Object ... parameters) {
        this.testers.add(new ConstructorTester<T>(Creator.byParams(this.modelClass, parameters)));
        return this;
    }

    public ModelTester<T> constructor(Creator<?> ... parameters) {
        this.testers.add(new ConstructorTester<T>(Creator.of(this.modelClass, parameters)));
        return this;
    }

    public ModelTester<T> getterSetters() {
        this.testers.add(new GetterSetterTester<T>(this.modelClass, null, null));
        return this;
    }

    public ModelTester<T> include(String ... names) {
        this.testers.add(new GetterSetterTester<T>(this.modelClass, Arrays.asList(names), null));
        return this;
    }

    public ModelTester<T> exclude(String ... names) {
        this.testers.add(new GetterSetterTester<T>(this.modelClass, null, Arrays.asList(names)));
        return this;
    }

    public ModelTester<T> equalsMethod() {
        this.testers.add(new EqualsTester<T>(this.modelClass));
        return this;
    }

    public ModelTester<T> equalsSafe() {
        this.testers.add(new EqualsTester<T>(this.modelClass, true));
        return this;
    }

    public ModelTester<T> hashCodeMethod() {
        this.testers.add(new HashCodeTester<T>(this.modelClass));
        return this;
    }

    public ModelTester<T> hashCodeSafe() {
        this.testers.add(new HashCodeTester<T>(this.modelClass, true));
        return this;
    }

    public ModelTester<T> toStringMethod() {
        this.testers.add(new ToStringTester<T>(this.modelClass));
        return this;
    }

    public ModelTester<T> toStringSafe() {
        this.testers.add(new ToStringTester<T>(this.modelClass, true));
        return this;
    }

    public boolean test() {
        boolean success = true;
        for (Tester tester : this.testers) {
            boolean result = tester.test();
            if (!success) continue;
            success = result;
        }
        return success;
    }

    public void testAndThrows() {
        if (!this.test()) {
            throw new TesterException("Fail when testing class <" + this.modelClass.getName() + ">");
        }
    }
}

