/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.model.tester;

import com.joutvhu.model.tester.Assert;
import com.joutvhu.model.tester.Creator;
import com.joutvhu.model.tester.Tester;

class ToStringTester<T>
implements Tester {
    private final Class<T> modelClass;
    private final boolean safe;

    ToStringTester(Class<T> modelClass) {
        this(modelClass, false);
    }

    ToStringTester(Class<T> modelClass, boolean safe) {
        this.modelClass = modelClass;
        this.safe = safe;
    }

    @Override
    public boolean test() {
        try {
            T model = Creator.anyOf(this.modelClass).create();
            boolean success = true;
            if (this.safe) {
                success = Assert.assertEquals(model.toString(), model.toString());
            } else {
                T newModel = Creator.makeCopy(model);
                success = Assert.assertEquals(model.toString(), newModel.toString());
            }
            if (success) {
                System.out.println("Success: " + this.modelClass.getName() + ".toString()");
            } else {
                System.err.println("Failure: " + this.modelClass.getName() + ".toString()");
            }
            return success;
        }
        catch (Throwable e) {
            System.err.println("Error: " + this.modelClass.getName() + ".toString()");
            e.printStackTrace();
            return false;
        }
    }
}

