/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.freemarker;

import com.joutvhu.dynamic.commons.DynamicQueryTemplate;
import com.joutvhu.dynamic.commons.DynamicQueryTemplateProvider;
import com.joutvhu.dynamic.freemarker.FreemarkerQueryTemplate;
import com.joutvhu.dynamic.freemarker.FreemarkerTemplateConfiguration;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerQueryTemplateProvider
extends DynamicQueryTemplateProvider {
    private static final Log log = LogFactory.getLog(FreemarkerQueryTemplateProvider.class);
    private final StringTemplateLoader sqlTemplateLoader = new StringTemplateLoader();
    private FreemarkerTemplateConfiguration configuration;
    private Configuration cfg;

    public void setConfiguration(FreemarkerTemplateConfiguration configuration) {
        this.configuration = configuration;
    }

    public DynamicQueryTemplate createTemplate(String name, String content) {
        try {
            return new FreemarkerQueryTemplate(name, content, this.cfg, this.encoding);
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    public DynamicQueryTemplate findTemplate(String name) {
        try {
            Template template = this.cfg.getTemplate(name, this.encoding);
            if (template != null) {
                return new FreemarkerQueryTemplate(template);
            }
        }
        catch (FileNotFoundException template) {
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return null;
    }

    protected void putTemplate(String name, String content) {
        Object src = this.sqlTemplateLoader.findTemplateSource(name);
        if (src != null) {
            log.warn((Object)("Found duplicate template key, will replace the value, key: " + name));
        }
        this.sqlTemplateLoader.putTemplate(name, content);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configuration == null) {
            this.configuration = FreemarkerTemplateConfiguration.instanceWithDefault();
        }
        this.configuration = this.configuration.templateLoader((TemplateLoader)this.sqlTemplateLoader);
        this.cfg = this.configuration.configuration();
        super.afterPropertiesSet();
    }
}

