/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.freemarker.directive;

import com.joutvhu.dynamic.commons.directive.TrimSymbol;
import com.joutvhu.dynamic.freemarker.io.TrimWriter;
import freemarker.core.Environment;
import freemarker.ext.beans.InvalidPropertyException;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrimDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (body != null) {
            TrimWriter.of(env.getOut(), this.createSymbol(params)).render(body);
        }
    }

    private TrimSymbol createSymbol(Map params) throws TemplateModelException {
        try {
            return new TrimSymbol(this.getStringParam(params, "prefix"), this.getListParam(params, "prefixOverrides"), this.getStringParam(params, "suffix"), this.getListParam(params, "suffixOverrides"));
        }
        catch (TemplateException | NullPointerException e) {
            throw new TemplateModelException(e.getMessage());
        }
    }

    private String getStringParam(Map<String, Object> params, String name) throws TemplateException {
        Object param;
        if (params.containsKey(name) && (param = params.get(name)) instanceof SimpleScalar) {
            return this.getStringFromSimpleScalar((SimpleScalar)param, name);
        }
        return null;
    }

    private String getStringFromSimpleScalar(SimpleScalar simpleScalar, String name) throws TemplateException {
        String value = simpleScalar.getAsString();
        if (value != null && !value.trim().isEmpty()) {
            return value;
        }
        throw new InvalidPropertyException("The " + name + " param cannot be empty string or spaces.");
    }

    private List<String> getListParam(Map<String, Object> params, String name) throws TemplateException {
        ArrayList<String> result = new ArrayList<String>();
        if (params.containsKey(name)) {
            Object param = params.get(name);
            if (param instanceof SimpleScalar) {
                result.add(this.getStringFromSimpleScalar((SimpleScalar)param, name));
            } else if (param instanceof SimpleSequence) {
                return this.getListFromSimpleSequence((SimpleSequence)param, name);
            }
        }
        return result;
    }

    private List<String> getListFromSimpleSequence(SimpleSequence simpleSequence, String name) throws TemplateException {
        ArrayList<String> result = new ArrayList<String>();
        int len = simpleSequence.size();
        for (int i = 0; i < len; ++i) {
            String value = simpleSequence.get(i).toString();
            if (value == null || value.trim().isEmpty()) {
                throw new InvalidPropertyException("The " + name + " param cannot be contains empty or spaces.");
            }
            result.add(value);
        }
        return result;
    }
}

