/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.freemarker.io;

import com.joutvhu.dynamic.commons.directive.TrimSymbol;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;

public class TrimWriter
extends Writer {
    private final Writer out;
    private final TrimSymbol symbol;
    private final StringBuilder contentBuilder = new StringBuilder();

    public static TrimWriter of(Writer out, TrimSymbol symbols) {
        return new TrimWriter(out, symbols);
    }

    public TrimWriter(Writer out, TrimSymbol symbol) {
        this.out = out;
        this.symbol = symbol;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        String content = String.copyValueOf(cbuf);
        this.contentBuilder.append(content);
    }

    public void afterWrite() throws IOException {
        String content = this.contentBuilder.toString();
        content = this.symbol.process(content);
        this.out.write(content);
    }

    public void render(TemplateDirectiveBody body) throws IOException, TemplateException {
        body.render((Writer)this);
        this.afterWrite();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

