/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.directive;

import freemarker.core.Environment;
import freemarker.ext.beans.InvalidPropertyException;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TrimDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        TrimSymbol symbols = new TrimSymbol(params);
        if (body != null) {
            TrimWriter.of(env.getOut(), symbols).render(body);
        }
    }

    public static class TrimSymbol {
        private String prefix;
        private List<String> prefixOverrides;
        private String suffix;
        private List<String> suffixOverrides;

        public TrimSymbol(String prefix, String suffix, String ... overrides) {
            this.prefix = prefix;
            this.suffix = suffix;
            ArrayList<String> listOverrides = new ArrayList<String>();
            Collections.addAll(listOverrides, overrides);
            this.prefixOverrides = listOverrides;
            this.suffixOverrides = listOverrides;
        }

        public TrimSymbol(Map<String, Object> params) throws TemplateException {
            this.prefix = this.getStringParam(params, "prefix");
            this.prefixOverrides = this.getListParam(params, "prefixOverrides");
            this.suffix = this.getStringParam(params, "suffix");
            this.suffixOverrides = this.getListParam(params, "suffixOverrides");
            if (this.prefix == null && this.prefixOverrides.isEmpty() && this.suffix == null && this.suffixOverrides.isEmpty()) {
                throw new TemplateModelException("The trim directive requires at least one of the following parameters: prefix, prefixOverrides, suffix, suffixOverrides");
            }
        }

        private String getStringParam(Map<String, Object> params, String name) throws TemplateException {
            Object param;
            if (params.containsKey(name) && (param = params.get(name)) instanceof SimpleScalar) {
                return this.getStringFromSimpleScalar((SimpleScalar)param, name);
            }
            return null;
        }

        private String getStringFromSimpleScalar(SimpleScalar simpleScalar, String name) throws TemplateException {
            String value = simpleScalar.getAsString();
            if (value != null && !value.trim().isEmpty()) {
                return value;
            }
            throw new InvalidPropertyException("The " + name + " param cannot be empty string or spaces.");
        }

        private List<String> getListParam(Map<String, Object> params, String name) throws TemplateException {
            ArrayList<String> result = new ArrayList<String>();
            if (params.containsKey(name)) {
                Object param = params.get(name);
                if (param instanceof SimpleScalar) {
                    result.add(this.getStringFromSimpleScalar((SimpleScalar)param, name));
                } else if (param instanceof SimpleSequence) {
                    return this.getListFromSimpleSequence((SimpleSequence)param, name);
                }
            }
            return result;
        }

        private List<String> getListFromSimpleSequence(SimpleSequence simpleSequence, String name) throws TemplateException {
            ArrayList<String> result = new ArrayList<String>();
            int len = simpleSequence.size();
            for (int i = 0; i < len; ++i) {
                String value = simpleSequence.get(i).toString();
                if (value == null || value.trim().isEmpty()) {
                    throw new InvalidPropertyException("The " + name + " param cannot be contains empty or spaces.");
                }
                result.add(value);
            }
            return result;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public List<String> getPrefixOverrides() {
            return this.prefixOverrides;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public List<String> getSuffixOverrides() {
            return this.suffixOverrides;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setPrefixOverrides(List<String> prefixOverrides) {
            this.prefixOverrides = prefixOverrides;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public void setSuffixOverrides(List<String> suffixOverrides) {
            this.suffixOverrides = suffixOverrides;
        }

        public TrimSymbol(String prefix, List<String> prefixOverrides, String suffix, List<String> suffixOverrides) {
            this.prefix = prefix;
            this.prefixOverrides = prefixOverrides;
            this.suffix = suffix;
            this.suffixOverrides = suffixOverrides;
        }
    }

    public static class TrimWriter
    extends Writer {
        private final Writer out;
        private final TrimSymbol symbols;
        private final StringBuffer contentBuffer = new StringBuffer();

        public static TrimWriter of(Writer out, TrimSymbol symbols) {
            return new TrimWriter(out, symbols);
        }

        public TrimWriter(Writer out, TrimSymbol symbols) {
            this.out = out;
            this.symbols = symbols;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String content = String.copyValueOf(cbuf);
            this.contentBuffer.append(content);
        }

        public void afterWrite() throws IOException {
            String content = this.contentBuffer.toString();
            for (String prefix : this.symbols.prefixOverrides) {
                content = Pattern.compile("^[ \\t\\n]*" + this.escapeRegular(prefix), 2).matcher(content).replaceAll("");
            }
            for (String suffix : this.symbols.suffixOverrides) {
                content = Pattern.compile(this.escapeRegular(suffix) + "[ \\t\\n]*$", 2).matcher(content).replaceAll("");
            }
            if (!(content = content.trim()).isEmpty()) {
                if (this.symbols.prefix != null) {
                    content = this.symbols.prefix + " " + content;
                }
                if (this.symbols.suffix != null) {
                    content = content + " " + this.symbols.suffix;
                }
            }
            content = " " + content + " ";
            this.out.write(content);
        }

        public void render(TemplateDirectiveBody body) throws IOException, TemplateException {
            body.render((Writer)this);
            this.afterWrite();
        }

        private String escapeRegular(String regex) {
            return Pattern.compile("([-/\\\\^$*+?.()|\\[\\]{}])").matcher(regex).replaceAll("\\\\$1");
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

