/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.query;

import com.joutvhu.dynamic.jpa.DynamicQuery;
import com.joutvhu.dynamic.jpa.DynamicQueryTemplates;
import com.joutvhu.dynamic.jpa.util.ApplicationContextHolder;
import com.joutvhu.dynamic.jpa.util.TemplateConfiguration;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DynamicJpaQueryMethod
extends JpaQueryMethod {
    private static final Map<String, String> templateMap = new HashMap<String, String>();
    private static Configuration cfg = TemplateConfiguration.instanceWithDefault().configuration();
    private final Method method;
    private final Lazy<Boolean> isNativeQuery;
    private Template queryTemplate;
    private Template countQueryTemplate;
    private Template countProjectionTemplate;

    protected DynamicJpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        super(method, metadata, factory, extractor);
        this.method = method;
        this.isNativeQuery = Lazy.of(() -> this.getMergedOrDefaultAnnotationValue("nativeQuery", DynamicQuery.class, Boolean.class));
    }

    protected Template findTemplate(String name) {
        DynamicQueryTemplates queryTemplates = ApplicationContextHolder.getBean(DynamicQueryTemplates.class);
        return queryTemplates != null ? queryTemplates.findTemplate(name) : null;
    }

    protected Template createTemplate(String name, String content) {
        try {
            return new Template(name, content, cfg);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Template getTemplate(String name) {
        String templateName = templateMap.get(name);
        if (StringUtils.hasText((String)templateName)) {
            templateName = "." + templateName;
        }
        templateName = this.getTemplateKey() + templateName;
        String query = this.getMergedOrDefaultAnnotationValue(name, DynamicQuery.class, String.class);
        this.queryTemplate = StringUtils.hasText((String)query) ? this.createTemplate(templateName, query) : this.findTemplate(templateName);
        return this.queryTemplate;
    }

    public boolean isNativeQuery() {
        return (Boolean)this.isNativeQuery.get();
    }

    @Nullable
    public Template getQueryTemplate() {
        if (this.queryTemplate == null) {
            this.queryTemplate = this.getTemplate("value");
        }
        return this.queryTemplate;
    }

    @Nullable
    public Template getCountQueryTemplate() {
        if (this.countQueryTemplate == null) {
            this.countQueryTemplate = this.getTemplate("countQuery");
        }
        return this.countQueryTemplate;
    }

    @Nullable
    public Template getCountProjectionTemplate() {
        if (this.countProjectionTemplate == null) {
            this.countProjectionTemplate = this.getTemplate("countProjection");
        }
        return this.countProjectionTemplate;
    }

    private String getEntityName() {
        return this.getEntityInformation().getJavaType().getSimpleName();
    }

    private String getTemplateKey() {
        return this.getEntityName() + ":" + this.getName();
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue((Class)annotationType, (String)attribute));
        }
        return targetType.cast(AnnotationUtils.getValue((Annotation)annotation, (String)attribute));
    }

    static {
        templateMap.put("value", "");
        templateMap.put("countQuery", "count");
        templateMap.put("countProjection", "projection");
    }
}

