/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa;

import com.joutvhu.dynamic.jpa.util.DynamicTemplateResolver;
import com.joutvhu.dynamic.jpa.util.TemplateConfiguration;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DynamicQueryTemplates
implements ResourceLoaderAware,
InitializingBean {
    private static final Logger log = LogManager.getLogger(DynamicQueryTemplates.class);
    private static StringTemplateLoader sqlTemplateLoader = new StringTemplateLoader();
    private static Configuration cfg = TemplateConfiguration.instanceWithDefault().templateLoader((TemplateLoader)sqlTemplateLoader).configuration();
    private String encoding = "UTF-8";
    private String templateLocation = "classpath:/query";
    private String suffix = ".dsql";
    private ResourceLoader resourceLoader;

    public Template findTemplate(String name) {
        try {
            return cfg.getTemplate(name, this.encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        Resource[] resources;
        String pattern = StringUtils.isNotBlank((CharSequence)this.templateLocation) ? (this.templateLocation.contains(this.suffix) ? this.templateLocation : this.templateLocation + "/**/*" + this.suffix) : "classpath:/**/*" + this.suffix;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        for (Resource resource : resources = resourcePatternResolver.getResources(pattern)) {
            DynamicTemplateResolver.of(resource).encoding(this.encoding).load((templateName, content) -> {
                Object src = sqlTemplateLoader.findTemplateSource(templateName);
                if (src != null) {
                    log.warn("Found duplicate template key, will replace the value, key: " + templateName);
                }
                sqlTemplateLoader.putTemplate(templateName, content);
            });
        }
    }
}

