/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.query;

import com.joutvhu.dynamic.commons.DynamicQueryTemplate;
import com.joutvhu.dynamic.commons.DynamicQueryTemplateProvider;
import com.joutvhu.dynamic.commons.util.ApplicationContextHolder;
import com.joutvhu.dynamic.jpa.DynamicQuery;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DynamicJpaQueryMethod
extends JpaQueryMethod {
    private static final Map<String, String> templateMap = new HashMap<String, String>();
    private final Method method;
    private final Lazy<Boolean> isNativeQuery;
    private DynamicQueryTemplateProvider queryTemplateProvider;
    private DynamicQueryTemplate queryTemplate;
    private DynamicQueryTemplate countQueryTemplate;
    private DynamicQueryTemplate countProjectionTemplate;

    protected DynamicJpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        super(method, metadata, factory, extractor);
        this.method = method;
        this.isNativeQuery = Lazy.of(() -> this.getMergedOrDefaultAnnotationValue("nativeQuery", DynamicQuery.class, Boolean.class));
    }

    private DynamicQueryTemplateProvider getTemplateProvider() {
        if (this.queryTemplateProvider == null) {
            this.queryTemplateProvider = (DynamicQueryTemplateProvider)ApplicationContextHolder.getBean(DynamicQueryTemplateProvider.class);
        }
        return this.queryTemplateProvider;
    }

    protected DynamicQueryTemplate findTemplate(String name) {
        DynamicQueryTemplateProvider provider = this.getTemplateProvider();
        return provider != null ? provider.findTemplate(name) : null;
    }

    protected DynamicQueryTemplate createTemplate(String name, String query) {
        DynamicQueryTemplateProvider provider = this.getTemplateProvider();
        return provider != null ? provider.createTemplate(name, query) : null;
    }

    protected DynamicQueryTemplate getTemplate(String name) {
        Object templateName = templateMap.get(name);
        if (StringUtils.hasText((String)templateName)) {
            templateName = "." + (String)templateName;
        }
        templateName = this.getTemplateKey() + (String)templateName;
        String query = this.getMergedOrDefaultAnnotationValue(name, DynamicQuery.class, String.class);
        this.queryTemplate = StringUtils.hasText((String)query) ? this.createTemplate((String)templateName, query) : this.findTemplate((String)templateName);
        return this.queryTemplate;
    }

    public boolean isNativeQuery() {
        return (Boolean)this.isNativeQuery.get();
    }

    @Nullable
    public DynamicQueryTemplate getQueryTemplate() {
        if (this.queryTemplate == null) {
            this.queryTemplate = this.getTemplate("value");
        }
        return this.queryTemplate;
    }

    @Nullable
    public DynamicQueryTemplate getCountQueryTemplate() {
        if (this.countQueryTemplate == null) {
            this.countQueryTemplate = this.getTemplate("countQuery");
        }
        return this.countQueryTemplate;
    }

    @Nullable
    public DynamicQueryTemplate getCountProjectionTemplate() {
        if (this.countProjectionTemplate == null) {
            this.countProjectionTemplate = this.getTemplate("countProjection");
        }
        return this.countProjectionTemplate;
    }

    private String getEntityName() {
        return this.getEntityInformation().getJavaType().getSimpleName();
    }

    private String getTemplateKey() {
        return this.getEntityName() + ":" + this.getName();
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue((Class)annotationType, (String)attribute));
        }
        return targetType.cast(AnnotationUtils.getValue((Annotation)annotation, (String)attribute));
    }

    public Class<? extends QueryRewriter> getQueryRewriter() {
        return this.getMergedOrDefaultAnnotationValue("queryRewriter", DynamicQuery.class, Class.class);
    }

    static {
        templateMap.put("value", "");
        templateMap.put("countQuery", "count");
        templateMap.put("countProjection", "projection");
    }
}

