/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.query;

import com.joutvhu.dynamic.commons.DynamicQueryTemplate;
import com.joutvhu.dynamic.jpa.query.DynamicJpaQueryMethod;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DynamicBasedStringQuery;
import org.springframework.data.jpa.repository.query.DynamicJpaParameterAccessor;
import org.springframework.data.jpa.repository.query.DynamicParameterBinderFactory;
import org.springframework.data.jpa.repository.query.DynamicQueryMetadataCache;
import org.springframework.data.jpa.repository.query.InvalidJpaQueryMethodException;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DynamicJpaRepositoryQuery
extends AbstractJpaQuery {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final DynamicJpaQueryMethod method;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final DynamicQueryMetadataCache metadataCache = new DynamicQueryMetadataCache();
    private final QueryRewriter queryRewriter;
    private JpaParametersParameterAccessor accessor;
    private DynamicBasedStringQuery query;
    private DynamicBasedStringQuery countQuery;
    private Lazy<ParameterBinder> parameterBinder;

    public DynamicJpaRepositoryQuery(DynamicJpaQueryMethod method, EntityManager em, QueryRewriter queryRewriter, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super((JpaQueryMethod)method, em);
        Assert.notNull((Object)evaluationContextProvider, (String)"ExpressionEvaluationContextProvider must not be null");
        Assert.notNull((Object)queryRewriter, (String)"QueryRewriter must not be null");
        this.method = method;
        this.queryRewriter = queryRewriter;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    protected String buildQuery(DynamicQueryTemplate template, JpaParametersParameterAccessor accessor) {
        try {
            if (template != null) {
                Map<String, Object> model = DynamicJpaParameterAccessor.of(accessor).getParamModel();
                String queryString = template.process(model).replaceAll("\n", " ").replaceAll("\t", " ").replaceAll(" +", " ").trim();
                return queryString.isEmpty() ? null : queryString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ParameterBinder createBinder() {
        return DynamicParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), (DeclaredQuery)this.query, PARSER, this.evaluationContextProvider);
    }

    protected DynamicBasedStringQuery setAccessor(JpaParametersParameterAccessor accessor) {
        if (this.query == null || this.accessor != accessor) {
            this.accessor = accessor;
            String queryString = this.buildQuery(this.method.getQueryTemplate(), accessor);
            this.query = new DynamicBasedStringQuery(queryString, this.method.getEntityInformation(), PARSER, this.method.isNativeQuery());
            this.parameterBinder = Lazy.of((Object)this.createBinder());
            this.validateQuery();
        }
        return this.query;
    }

    protected Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        this.setAccessor(accessor);
        String sortedQueryString = QueryEnhancerFactory.forQuery((DeclaredQuery)this.query).applySorting(accessor.getSort(), this.query.getAlias());
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Query query = this.createJpaQuery(sortedQueryString, accessor.getSort(), accessor.getPageable(), processor.getReturnedType());
        return this.metadataCache.bindAndPrepare(sortedQueryString, query, accessor, this.parameterBinder);
    }

    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        this.setAccessor(accessor);
        String countQueryString = this.buildQuery(this.method.getCountQueryTemplate(), accessor);
        String countProjectionString = this.buildQuery(this.method.getCountProjectionTemplate(), accessor);
        this.countQuery = new DynamicBasedStringQuery(this.query.deriveCountQuery(countQueryString, countProjectionString), this.method.getEntityInformation(), PARSER, this.method.isNativeQuery());
        if (!this.method.isNativeQuery() && this.method.isPageQuery()) {
            this.validateQuery(this.countQuery.getQueryString(), "Count query validation failed for method %s!");
        }
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        Query query = this.method.isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class);
        this.metadataCache.bind(queryString, query, accessor, this.parameterBinder);
        return query;
    }

    protected Query createJpaQuery(String queryString, Sort sort, @Nullable Pageable pageable, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        queryString = this.potentiallyRewriteQuery(queryString, sort, pageable);
        if (this.method.isNativeQuery()) {
            Class<?> type = this.getTypeToQueryFor(returnedType);
            return type == null ? em.createNativeQuery(queryString) : em.createNativeQuery(queryString, type);
        }
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryString);
        }
        Class typeToRead = this.getTypeToRead(returnedType);
        return typeToRead == null ? em.createQuery(queryString) : em.createQuery(queryString, typeToRead);
    }

    @Nullable
    private Class<?> getTypeToQueryFor(ReturnedType returnedType) {
        Class<Tuple> result;
        Class<Tuple> clazz = result = this.getQueryMethod().isQueryForEntity() ? returnedType.getDomainType() : null;
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return result;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Tuple.class : result;
    }

    private void validateQuery() {
        if (this.method.isNativeQuery()) {
            JpaParameters parameters = this.method.getParameters();
            if (parameters.hasSortParameter() && !this.query.getQueryString().contains("#sort")) {
                throw new InvalidJpaQueryMethodException(String.format("Cannot use native queries with dynamic sorting in method %s", new Object[]{this.method}));
            }
        } else {
            this.validateQuery(this.query.getQueryString(), "Validation failed for query for method %s!");
        }
    }

    private void validateQuery(String query, String errorMessage) {
        EntityManager validatingEm = null;
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        try {
            validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();
            validatingEm.createQuery(query);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format(errorMessage, new Object[]{this.method}), e);
        }
        finally {
            if (validatingEm != null) {
                validatingEm.close();
            }
        }
    }

    protected String potentiallyRewriteQuery(String originalQuery, Sort sort, @Nullable Pageable pageable) {
        return pageable != null && pageable.isPaged() ? this.queryRewriter.rewrite(originalQuery, pageable) : this.queryRewriter.rewrite(originalQuery, sort);
    }
}

