/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.support;

import com.joutvhu.dynamic.jpa.query.DynamicJpaQueryLookupStrategy;
import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.DefaultJpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;

public class DynamicJpaRepositoryFactory
extends JpaRepositoryFactory {
    private final EntityManager entityManager;
    private final QueryExtractor extractor;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    private JpaQueryMethodFactory queryMethodFactory;
    private QueryRewriterProvider queryRewriterProvider;

    public DynamicJpaRepositoryFactory(EntityManager entityManager) {
        super(entityManager);
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager((EntityManager)entityManager);
        this.queryMethodFactory = new DefaultJpaQueryMethodFactory(this.extractor);
        this.queryRewriterProvider = QueryRewriterProvider.simple();
        super.setQueryMethodFactory(this.queryMethodFactory);
    }

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        super.setEscapeCharacter(escapeCharacter);
        this.escapeCharacter = escapeCharacter;
    }

    public void setQueryMethodFactory(JpaQueryMethodFactory queryMethodFactory) {
        super.setQueryMethodFactory(queryMethodFactory);
        this.queryMethodFactory = queryMethodFactory;
    }

    public void setQueryRewriterProvider(QueryRewriterProvider queryRewriterProvider) {
        super.setQueryRewriterProvider(queryRewriterProvider);
        this.queryRewriterProvider = queryRewriterProvider;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(DynamicJpaQueryLookupStrategy.create(this.entityManager, this.queryMethodFactory, key, this.extractor, evaluationContextProvider, this.queryRewriterProvider, this.escapeCharacter));
    }
}

