/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jpa.support;

import com.joutvhu.dynamic.commons.util.ApplicationContextHolder;
import com.joutvhu.dynamic.jpa.support.DynamicJpaRepositoryFactory;
import jakarta.persistence.EntityManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;

public class DynamicJpaRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends JpaRepositoryFactoryBean<T, S, ID>
implements ApplicationContextAware {
    private EntityPathResolver entityPathResolver;
    private JpaQueryMethodFactory queryMethodFactory;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;

    public DynamicJpaRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        DynamicJpaRepositoryFactory jpaRepositoryFactory = new DynamicJpaRepositoryFactory(entityManager);
        jpaRepositoryFactory.setEntityPathResolver(this.entityPathResolver);
        jpaRepositoryFactory.setEscapeCharacter(this.escapeCharacter);
        if (this.queryMethodFactory != null) {
            jpaRepositoryFactory.setQueryMethodFactory(this.queryMethodFactory);
        }
        return jpaRepositoryFactory;
    }

    @Autowired
    public void setEntityPathResolver(ObjectProvider<EntityPathResolver> resolver) {
        this.entityPathResolver = (EntityPathResolver)resolver.getIfAvailable(() -> SimpleEntityPathResolver.INSTANCE);
    }

    @Autowired
    public void setQueryMethodFactory(@Nullable JpaQueryMethodFactory factory) {
        if (factory != null) {
            this.queryMethodFactory = factory;
        }
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = EscapeCharacter.of((char)escapeCharacter);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHolder.appContext = applicationContext;
    }
}

