/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.spring.formjson;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.joutvhu.spring.formjson.FormJson;
import com.joutvhu.spring.formjson.FormJsonSerializer;
import java.util.ArrayList;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.service.invoker.AbstractNamedValueArgumentResolver;
import org.springframework.web.service.invoker.HttpRequestValues;

public class FormJsonArgumentResolver
extends AbstractNamedValueArgumentResolver {
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        FormJson ann = (FormJson)parameter.getParameterAnnotation(FormJson.class);
        return ann != null ? new AbstractNamedValueArgumentResolver.NamedValueInfo(ann.name(), false, null, "request form json", false) : null;
    }

    protected void addRequestValue(String name, Object value, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(MultipartFile.class, (JsonSerializer)new FormJsonSerializer(files));
        mapper.registerModule((Module)module);
        String data = mapper.writeValueAsString(value);
        if (data != null && StringUtils.hasText((String)data)) {
            requestValues.addRequestPart(name, (Object)data);
            for (MultipartFile file : files) {
                requestValues.addRequestPart(file.getName(), (Object)file);
            }
        }
    }
}

