/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.spring.formjson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.joutvhu.spring.formjson.FormJson;
import com.joutvhu.spring.formjson.FormJsonDeserializer;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class FormJsonMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        FormJson ann = (FormJson)parameter.getParameterAnnotation(FormJson.class);
        return ann != null ? new AbstractNamedValueMethodArgumentResolver.NamedValueInfo(ann.name(), false, null) : null;
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        String dataValue;
        MultipartRequest multipartRequest = (MultipartRequest)request.getNativeRequest(MultipartRequest.class);
        if (multipartRequest != null && (dataValue = request.getParameter(name)) != null) {
            Class modelType = parameter.getParameterType();
            ObjectMapper mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addDeserializer(MultipartFile.class, (JsonDeserializer)new FormJsonDeserializer(multipartRequest));
            mapper.registerModule((Module)module);
            return mapper.readValue(dataValue, modelType);
        }
        return null;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(FormJson.class)) {
            FormJson ann = (FormJson)parameter.getParameterAnnotation(FormJson.class);
            return ann != null && StringUtils.hasText((String)ann.name());
        }
        return false;
    }
}

