/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.spring.formjson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class FormJsonSerializer
extends JsonSerializer<MultipartFile> {
    private List<MultipartFile> files;

    public FormJsonSerializer(List<MultipartFile> files) {
        this.files = files;
    }

    public void serialize(final MultipartFile multipartFile, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        final String key = "file_" + this.files.size();
        this.files.add(new MultipartFile(){

            public String getName() {
                return key;
            }

            public String getOriginalFilename() {
                return multipartFile.getOriginalFilename();
            }

            public String getContentType() {
                return multipartFile.getContentType();
            }

            public boolean isEmpty() {
                return multipartFile.isEmpty();
            }

            public long getSize() {
                return multipartFile.getSize();
            }

            public byte[] getBytes() throws IOException {
                return multipartFile.getBytes();
            }

            public InputStream getInputStream() throws IOException {
                return multipartFile.getInputStream();
            }

            public void transferTo(File dest) throws IOException, IllegalStateException {
                multipartFile.transferTo(dest);
            }
        });
        jsonGenerator.writeString(key);
    }
}

