/*
 * Decompiled with CFR 0.152.
 */
package com.github.jparkie.promise;

import com.github.jparkie.promise.Action;
import com.github.jparkie.promise.Function;
import com.github.jparkie.promise.Promise;
import com.github.jparkie.promise.Scheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class Promises {
    private Promises() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static <T> Promise<T> create(Scheduler scheduler, final Action<T> onScheduleAction) {
        DefaultPromise createPromise = new DefaultPromise();
        createPromise.then(scheduler, new Action<T>(){

            @Override
            public void call(Promise<T> promise) {
            }

            @Override
            public void cancel() {
                onScheduleAction.cancel();
            }
        });
        scheduler.schedule(onScheduleAction, createPromise);
        return createPromise;
    }

    public static <T> Promise<T> promise() {
        return new DefaultPromise();
    }

    public static <T> Promise<T> value(T value) {
        DefaultPromise<T> promise = new DefaultPromise<T>();
        promise.set(value);
        return promise;
    }

    public static <T> Promise<T> error(Throwable error) {
        DefaultPromise promise = new DefaultPromise();
        promise.setError(error);
        return promise;
    }

    private static final class DefaultPromise<T>
    implements Promise<T> {
        private final Object promiseLock = new Object();
        private final CountDownLatch awaitLatch = new CountDownLatch(1);
        private final List<ActionContext<T>> actionContexts = new ArrayList<ActionContext<T>>();
        private volatile T value;
        private volatile Throwable error;
        private volatile boolean cancelFlag;
        private volatile boolean promiseFlag;

        private DefaultPromise() {
        }

        @Override
        public boolean isCancelled() {
            return this.cancelFlag;
        }

        @Override
        public boolean isDone() {
            return this.promiseFlag;
        }

        @Override
        public boolean isSuccessful() {
            return this.isDone() && this.error == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            ArrayList<ActionContext<T>> temporaryActionContexts;
            this.cancelFlag = true;
            Iterator iterator = this.promiseLock;
            synchronized (iterator) {
                temporaryActionContexts = new ArrayList<ActionContext<T>>(this.actionContexts);
                this.actionContexts.clear();
            }
            for (ActionContext actionContext : temporaryActionContexts) {
                actionContext.scheduler.cancel(actionContext.action);
            }
            this.awaitLatch.countDown();
        }

        @Override
        public void await() throws InterruptedException {
            this.awaitLatch.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.awaitLatch.await(timeout, unit);
        }

        @Override
        public T get() throws IllegalStateException {
            if (!this.isCancelled() && !this.isDone()) {
                throw new IllegalStateException();
            }
            return this.value;
        }

        @Override
        public Throwable getError() throws IllegalStateException {
            if (!this.isCancelled() && !this.isDone()) {
                throw new IllegalStateException();
            }
            return this.error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T value) {
            ArrayList<ActionContext<T>> temporaryActionContexts;
            if (this.isCancelled()) {
                return;
            }
            Iterator iterator = this.promiseLock;
            synchronized (iterator) {
                if (this.isDone()) {
                    throw new IllegalStateException();
                }
                this.value = value;
                this.error = null;
                this.promiseFlag = true;
                temporaryActionContexts = new ArrayList<ActionContext<T>>(this.actionContexts);
                this.actionContexts.clear();
            }
            for (ActionContext actionContext : temporaryActionContexts) {
                actionContext.scheduler.schedule(actionContext.action, this);
            }
            this.awaitLatch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setError(Throwable error) {
            ArrayList<ActionContext<T>> temporaryActionContexts;
            if (this.isCancelled()) {
                return;
            }
            Iterator iterator = this.promiseLock;
            synchronized (iterator) {
                if (this.isDone()) {
                    throw new IllegalStateException();
                }
                this.value = null;
                this.error = error;
                this.promiseFlag = true;
                temporaryActionContexts = new ArrayList<ActionContext<T>>(this.actionContexts);
                this.actionContexts.clear();
            }
            for (ActionContext actionContext : temporaryActionContexts) {
                actionContext.scheduler.schedule(actionContext.action, this);
            }
            this.awaitLatch.countDown();
        }

        @Override
        public <U> Promise<U> then(Scheduler scheduler, Function<T, U> function) {
            DefaultPromise<T> deferredPromise = new DefaultPromise<T>();
            if (this.isCancelled()) {
                deferredPromise.cancel();
            } else {
                this.then(scheduler, new FunctionAction(deferredPromise, scheduler, function));
            }
            return deferredPromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void then(Scheduler scheduler, Action<T> action) {
            if (this.isCancelled()) {
                scheduler.cancel(action);
                return;
            }
            Object object = this.promiseLock;
            synchronized (object) {
                if (!this.isDone()) {
                    this.actionContexts.add(new ActionContext(scheduler, action));
                } else {
                    scheduler.schedule(action, this);
                }
            }
        }

        private static final class FunctionAction<T, U>
        implements Action<T> {
            private final Promise<U> deferredPromise;
            private final Scheduler scheduler;
            private final Function<T, U> function;

            private FunctionAction(Promise<U> deferredPromise, Scheduler scheduler, Function<T, U> function) {
                this.deferredPromise = deferredPromise;
                this.scheduler = scheduler;
                this.function = function;
            }

            @Override
            public void call(Promise<T> promise) {
                Promise<U> calledPromise = this.function.call(promise);
                calledPromise.then(this.scheduler, new Action<U>(){

                    @Override
                    public void call(Promise<U> completedPromise) {
                        if (completedPromise.isSuccessful()) {
                            FunctionAction.this.deferredPromise.set(completedPromise.get());
                        } else {
                            FunctionAction.this.deferredPromise.setError(completedPromise.getError());
                        }
                    }

                    @Override
                    public void cancel() {
                        if (!FunctionAction.this.deferredPromise.isCancelled()) {
                            FunctionAction.this.deferredPromise.cancel();
                        }
                    }
                });
            }

            @Override
            public void cancel() {
                if (!this.deferredPromise.isCancelled()) {
                    this.deferredPromise.cancel();
                }
            }
        }

        private static final class ActionContext<T> {
            private final Scheduler scheduler;
            private final Action<T> action;

            private ActionContext(Scheduler scheduler, Action<T> action) {
                this.scheduler = scheduler;
                this.action = action;
            }
        }
    }
}

