/*
 * Decompiled with CFR 0.152.
 */
package com.github.jparkie.promise;

import com.github.jparkie.promise.Action;
import com.github.jparkie.promise.Promise;
import com.github.jparkie.promise.Scheduler;
import java.util.concurrent.ExecutorService;

public final class Schedulers {
    private Schedulers() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static Scheduler newSimpleScheduler() {
        return new SimpleScheduler();
    }

    public static Scheduler newExecutorServiceScheduler(ExecutorService executorService) {
        return new ExecutorServiceScheduler(executorService);
    }

    private static class ExecutorServiceScheduler
    implements Scheduler {
        private final ExecutorService executorService;

        ExecutorServiceScheduler(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public <T> void schedule(final Action<T> action, final Promise<T> promise) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    action.call(promise);
                }
            });
        }

        @Override
        public <T> void cancel(final Action<T> action) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    action.cancel();
                }
            });
        }
    }

    private static class SimpleScheduler
    implements Scheduler {
        private SimpleScheduler() {
        }

        @Override
        public <T> void schedule(Action<T> action, Promise<T> promise) {
            action.call(promise);
        }

        @Override
        public <T> void cancel(Action<T> action) {
            action.cancel();
        }
    }
}

