/*
 * Decompiled with CFR 0.152.
 */
package com.github.jparkie.promise.extras;

import com.github.jparkie.promise.Action;
import com.github.jparkie.promise.Promise;
import com.github.jparkie.promise.Promises;
import com.github.jparkie.promise.Scheduler;
import com.github.jparkie.promise.extras.Pair;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ExtraPromises {
    private ExtraPromises() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static <T> Promise<T> firstCompletedOf(Scheduler scheduler, Promise<T> ... promises) {
        final Object sequenceLock = new Object();
        final AtomicInteger cancelCounter = new AtomicInteger(promises.length);
        final Promise firstCompletedPromise = Promises.promise();
        for (Promise<T> promise : promises) {
            promise.then(scheduler, new Action<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call(Promise<T> promise) {
                    Object object = sequenceLock;
                    synchronized (object) {
                        if (firstCompletedPromise.isDone()) {
                            return;
                        }
                        if (promise.isSuccessful()) {
                            firstCompletedPromise.set(promise.get());
                        } else {
                            firstCompletedPromise.setError(promise.getError());
                        }
                    }
                }

                @Override
                public void cancel() {
                    if (cancelCounter.decrementAndGet() == 0 && !firstCompletedPromise.isCancelled()) {
                        firstCompletedPromise.cancel();
                    }
                }
            });
        }
        return firstCompletedPromise;
    }

    public static Promise<Void> whenAll(Scheduler scheduler, Promise<?> ... promises) {
        final Object sequenceLock = new Object();
        final AtomicInteger callCounter = new AtomicInteger(promises.length);
        final AtomicInteger cancelCounter = new AtomicInteger(promises.length);
        final Promise<Void> whenAllPromise = Promises.promise();
        for (Promise<?> promise : promises) {
            promise.then(scheduler, new Action(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call(Promise promise) {
                    Object object = sequenceLock;
                    synchronized (object) {
                        if (whenAllPromise.isDone()) {
                            return;
                        }
                        if (!promise.isSuccessful()) {
                            whenAllPromise.setError(promise.getError());
                            return;
                        }
                        if (callCounter.decrementAndGet() == 0) {
                            whenAllPromise.set(null);
                        }
                    }
                }

                @Override
                public void cancel() {
                    if (cancelCounter.decrementAndGet() == 0 && !whenAllPromise.isCancelled()) {
                        whenAllPromise.cancel();
                    }
                }
            });
        }
        return whenAllPromise;
    }

    public static <T, U> Promise<Pair<T, U>> zip(Scheduler scheduler, Promise<T> tPromise, Promise<U> uPromise) {
        final Object sequenceLock = new Object();
        final AtomicBoolean leftFlag = new AtomicBoolean(false);
        final AtomicBoolean rightFlag = new AtomicBoolean(false);
        final AtomicReference<Object> leftReference = new AtomicReference<Object>(null);
        final AtomicReference<Object> rightReference = new AtomicReference<Object>(null);
        final Promise<Pair<T, U>> zippedPromise = Promises.promise();
        tPromise.then(scheduler, new Action<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(Promise<T> promise) {
                Object object = sequenceLock;
                synchronized (object) {
                    if (zippedPromise.isDone()) {
                        return;
                    }
                    if (!promise.isSuccessful()) {
                        zippedPromise.setError(promise.getError());
                        return;
                    }
                    leftFlag.set(true);
                    leftReference.set(promise.get());
                    if (leftFlag.get() && rightFlag.get()) {
                        zippedPromise.set(Pair.create(leftReference.get(), rightReference.get()));
                    }
                }
            }

            @Override
            public void cancel() {
                if (!zippedPromise.isCancelled()) {
                    zippedPromise.cancel();
                }
            }
        });
        uPromise.then(scheduler, new Action<U>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(Promise<U> promise) {
                Object object = sequenceLock;
                synchronized (object) {
                    if (zippedPromise.isDone()) {
                        return;
                    }
                    if (!promise.isSuccessful()) {
                        zippedPromise.setError(promise.getError());
                        return;
                    }
                    rightFlag.set(true);
                    rightReference.set(promise.get());
                    if (leftFlag.get() && rightFlag.get()) {
                        zippedPromise.set(Pair.create(leftReference.get(), rightReference.get()));
                    }
                }
            }

            @Override
            public void cancel() {
                if (!zippedPromise.isCancelled()) {
                    zippedPromise.cancel();
                }
            }
        });
        return zippedPromise;
    }
}

