/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrcodeza.schema.generator.plugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jrcodeza.schema.generator.OpenAPIGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generateOpenApi", defaultPhase=LifecyclePhase.INSTALL)
public class GenerateOpenApiSchemaMojo
extends AbstractMojo {
    @Parameter
    private String title;
    @Parameter
    private String description;
    @Parameter
    private String version;
    @Parameter
    private String[] modelPackages;
    @Parameter
    private String[] controllerBasePackages;
    @Parameter
    private String outputDirectory;

    public void execute() {
        OpenAPIGenerator openApiGenerator = new OpenAPIGenerator(Arrays.asList(this.modelPackages), Arrays.asList(this.controllerBasePackages), this.createInfoFromParameters());
        OpenAPI openAPI = openApiGenerator.generate();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            if (!new File(this.outputDirectory).mkdirs()) {
                this.getLog().error((CharSequence)String.format("Error creating directories for path [%s]", this.outputDirectory));
                return;
            }
            objectMapper.writeValue(new File(this.outputDirectory + "/swagger.json"), (Object)openAPI);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot serialize generated OpenAPI spec", (Throwable)e);
        }
    }

    private Info createInfoFromParameters() {
        Info info = new Info();
        info.setTitle(this.title);
        info.setDescription(this.description);
        info.setVersion(this.version);
        return info;
    }
}

