/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrcodeza.schema.generator.plugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jrcodeza.schema.generator.OpenAPIGenerator;
import com.github.jrcodeza.schema.generator.config.OpenApiGeneratorConfig;
import com.github.jrcodeza.schema.generator.config.builder.OpenApiGeneratorConfigBuilder;
import com.github.jrcodeza.schema.generator.interceptors.OperationInterceptor;
import com.github.jrcodeza.schema.generator.interceptors.OperationParameterInterceptor;
import com.github.jrcodeza.schema.generator.interceptors.RequestBodyInterceptor;
import com.github.jrcodeza.schema.generator.interceptors.SchemaFieldInterceptor;
import com.github.jrcodeza.schema.generator.interceptors.SchemaInterceptor;
import com.github.jrcodeza.schema.generator.interceptors.examples.OpenApiExampleResolver;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generateOpenApi", defaultPhase=LifecyclePhase.INSTALL)
public class GenerateOpenApiSchemaMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String title;
    @Parameter
    private String description;
    @Parameter(required=true)
    private String version;
    @Parameter(required=true)
    private String[] modelPackages;
    @Parameter(required=true)
    private String[] controllerBasePackages;
    @Parameter(required=true)
    private String outputDirectory;
    @Parameter
    private List<String> schemaInterceptors;
    @Parameter
    private List<String> schemaFieldInterceptors;
    @Parameter
    private List<String> operationParameterInterceptors;
    @Parameter
    private List<String> operationInterceptors;
    @Parameter
    private List<String> requestBodyInterceptors;
    @Parameter
    private Boolean generateExamples;
    @Parameter
    private String openApiExamplesResolver;

    public void execute() {
        OpenAPIGenerator openApiGenerator = new OpenAPIGenerator(Arrays.asList(this.modelPackages), Arrays.asList(this.controllerBasePackages), this.createInfoFromParameters(), this.parseInputInterceptors(this.schemaInterceptors, SchemaInterceptor.class), this.parseInputInterceptors(this.schemaFieldInterceptors, SchemaFieldInterceptor.class), this.parseInputInterceptors(this.operationParameterInterceptors, OperationParameterInterceptor.class), this.parseInputInterceptors(this.operationInterceptors, OperationInterceptor.class), this.parseInputInterceptors(this.requestBodyInterceptors, RequestBodyInterceptor.class));
        OpenApiGeneratorConfig openApiGeneratorConfig = OpenApiGeneratorConfigBuilder.defaultConfig().build();
        if (BooleanUtils.isTrue((Boolean)this.generateExamples)) {
            openApiGeneratorConfig.setGenerateExamples(true);
            if (StringUtils.isNotBlank((CharSequence)this.openApiExamplesResolver)) {
                openApiGeneratorConfig.setOpenApiExampleResolver(this.instantiateClass(this.openApiExamplesResolver, OpenApiExampleResolver.class));
            }
        }
        OpenAPI openAPI = openApiGenerator.generate(openApiGeneratorConfig);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            if (!new File(this.outputDirectory).mkdirs()) {
                this.getLog().error((CharSequence)String.format("Error creating directories for path [%s]", this.outputDirectory));
                return;
            }
            objectMapper.writeValue(new File(this.outputDirectory + "/swagger.json"), (Object)openAPI);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot serialize generated OpenAPI spec", (Throwable)e);
        }
    }

    private <T> List<T> parseInputInterceptors(List<String> classNames, Class<T> clazz) {
        if (classNames == null || classNames.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (String className : classNames) {
            result.add(this.instantiateClass(className, clazz));
        }
        return result;
    }

    private <T> T instantiateClass(String className, Class<T> superClass) {
        try {
            Class<?> inputClass = Class.forName(className);
            if (superClass.isAssignableFrom(inputClass)) {
                return (T)inputClass.newInstance();
            }
            this.getLog().error((CharSequence)String.format("Incorrect class type = [%s]. Expected is = [%s]", className, superClass.getName()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getLog().error((CharSequence)e.getMessage());
            System.exit(1);
        }
        return null;
    }

    private Info createInfoFromParameters() {
        Info info = new Info();
        info.setTitle(this.title);
        info.setDescription(this.description);
        info.setVersion(this.version);
        return info;
    }
}

