/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.data;

import com.github.jrh3k5.plugin.maven.l10n.data.AbstractMessagesProperties;
import com.github.jrh3k5.plugin.maven.l10n.data.AbstractMessagesPropertiesParser;
import com.github.jrh3k5.plugin.maven.l10n.data.TranslationClass;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AuthoritativeMessagesProperties
extends AbstractMessagesProperties {
    private final Collection<TranslationClass> translationClasses;

    private static Collection<TranslationClass> parseTranslationClasses(Collection<String> translationKeys) {
        HashMap classStaging = new HashMap();
        for (String translationKey : translationKeys) {
            int lastPeriodPos = translationKey.lastIndexOf(46);
            if (lastPeriodPos < 0) continue;
            String className = AuthoritativeMessagesProperties.sanitizeClassName(translationKey.substring(0, lastPeriodPos));
            String keyName = translationKey.substring(lastPeriodPos + 1);
            if (classStaging.containsKey(className)) {
                ((Set)classStaging.get(className)).add(keyName);
                continue;
            }
            HashSet<String> keys = new HashSet<String>();
            keys.add(keyName);
            classStaging.put(className, keys);
        }
        ArrayList<TranslationClass> translationClasses = new ArrayList<TranslationClass>();
        for (Map.Entry stagedClass : classStaging.entrySet()) {
            translationClasses.add(new TranslationClass((String)stagedClass.getKey(), (Set)stagedClass.getValue()));
        }
        return translationClasses;
    }

    private static String sanitizeClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length < 2) {
            return className;
        }
        ArrayList<String> packageComponents = new ArrayList<String>();
        String rootClassName = null;
        ArrayList<String> nestedClassNames = new ArrayList<String>();
        for (String part : parts) {
            if (part.equals(part.toLowerCase(Locale.US))) {
                packageComponents.add(part);
                continue;
            }
            if (rootClassName == null) {
                rootClassName = part;
                continue;
            }
            nestedClassNames.add(part);
        }
        String packageName = StringUtils.join(packageComponents, (String)".");
        return nestedClassNames.isEmpty() ? String.format("%s.%s", packageName, rootClassName) : String.format("%s.%s$%s", packageName, rootClassName, StringUtils.join(nestedClassNames, (String)"$"));
    }

    private AuthoritativeMessagesProperties(File file, Locale supportedLocale, Set<String> translationKeys, Set<String> duplicateTranslationKeys) {
        super(file, supportedLocale, translationKeys, duplicateTranslationKeys);
        this.translationClasses = Collections.unmodifiableCollection(AuthoritativeMessagesProperties.parseTranslationClasses(translationKeys));
    }

    public Collection<TranslationClass> getTranslationClasses() {
        return this.translationClasses;
    }

    public static class Parser
    extends AbstractMessagesPropertiesParser {
        public AuthoritativeMessagesProperties parse(File file) throws IOException {
            return new AuthoritativeMessagesProperties(file, this.determineSupportedLocale(file), this.getTranslationKeys(file), this.getDuplicateTranslationKeys(file));
        }
    }
}

