/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.data;

import com.github.jrh3k5.plugin.maven.l10n.data.AbstractMessagesProperties;
import com.github.jrh3k5.plugin.maven.l10n.data.AbstractMessagesPropertiesParser;
import com.github.jrh3k5.plugin.maven.l10n.data.AuthoritativeMessagesProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TranslatedMessagesProperties
extends AbstractMessagesProperties
implements Comparable<TranslatedMessagesProperties> {
    private final SortedSet<String> missingTranslationKeys;
    private final Set<String> extraTranslationKeys;

    private TranslatedMessagesProperties(File file, Locale supportedLocale, Set<String> translationKeys, Set<String> missingTranslationKeys, Set<String> extraTranslationKeys, Set<String> duplicateTranslationKeys) {
        super(file, supportedLocale, translationKeys, duplicateTranslationKeys);
        this.missingTranslationKeys = Collections.unmodifiableSortedSet(new TreeSet<String>(missingTranslationKeys));
        this.extraTranslationKeys = Collections.unmodifiableSet(extraTranslationKeys);
    }

    @Override
    public int compareTo(TranslatedMessagesProperties o) {
        return this.getFile().getName().compareTo(o.getFile().getName());
    }

    public SortedSet<String> getMissingTranslationKeys() {
        return this.missingTranslationKeys;
    }

    public Set<String> getExtraTranslationKeys() {
        return this.extraTranslationKeys;
    }

    public static class Parser
    extends AbstractMessagesPropertiesParser {
        public Collection<TranslatedMessagesProperties> parse(AuthoritativeMessagesProperties authoritativeMessagesProperties, Collection<File> messagesFiles) throws IOException {
            ArrayList<TranslatedMessagesProperties> translated = new ArrayList<TranslatedMessagesProperties>(messagesFiles.size());
            for (File messagesFile : messagesFiles) {
                Set<String> translationKeys = this.getTranslationKeys(messagesFile);
                HashSet<String> missingTranslationKeys = new HashSet<String>();
                for (String authoritativeTranslationKey : authoritativeMessagesProperties.getTranslationKeys()) {
                    if (translationKeys.contains(authoritativeTranslationKey)) continue;
                    missingTranslationKeys.add(authoritativeTranslationKey);
                }
                HashSet<String> extraTranslationKeys = new HashSet<String>();
                for (String translationKey : translationKeys) {
                    if (authoritativeMessagesProperties.getTranslationKeys().contains(translationKey)) continue;
                    extraTranslationKeys.add(translationKey);
                }
                translated.add(new TranslatedMessagesProperties(messagesFile, this.determineSupportedLocale(messagesFile), translationKeys, missingTranslationKeys, extraTranslationKeys, this.getDuplicateTranslationKeys(messagesFile)));
            }
            return Collections.unmodifiableCollection(translated);
        }
    }
}

