/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.mojo.report;

import com.github.jrh3k5.plugin.maven.l10n.data.AuthoritativeMessagesProperties;
import com.github.jrh3k5.plugin.maven.l10n.data.MissingTranslationKey;
import com.github.jrh3k5.plugin.maven.l10n.data.MissingTranslationKeyClass;
import com.github.jrh3k5.plugin.maven.l10n.data.TranslatedMessagesProperties;
import com.github.jrh3k5.plugin.maven.l10n.util.ClassLoaderUtils;
import com.github.jrh3k5.plugin.maven.l10n.util.TranslationClassUtils;
import com.github.jrh3k5.plugin.maven.l10n.util.TranslationKeyAnalysisUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="translation-key-verifification", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class TranslationKeyVerifier
extends AbstractMavenReport {
    private static final String OUTPUT_NAME = "translation-key-verification";
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/messages.properties")
    private File messagesFile;
    @Parameter(required=true, defaultValue="src/main/resources/messages*.properties")
    private String translatedMessagesPattern;
    @Parameter(required=true, readonly=true, defaultValue="${descriptor}")
    private PluginDescriptor pluginDescriptor;
    @Parameter(required=false)
    private List<String> keyClasses = Collections.emptyList();

    public String getOutputName() {
        return OUTPUT_NAME;
    }

    public String getName(Locale locale) {
        return "Translation Key Verification";
    }

    public String getDescription(Locale locale) {
        return "A report that alerts to missing or invalid translation keys";
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Collection<String> translationClassKeys;
        TranslationKeyAnalysisUtils.ClassinessAnalysisResults analysisResults;
        Collection<TranslatedMessagesProperties> translatedProperties;
        AuthoritativeMessagesProperties authoritativeProperties;
        ClassLoader classLoader;
        try {
            classLoader = ClassLoaderUtils.getClassLoader(this.getProject());
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to load project classloader.", (Exception)e);
        }
        try {
            authoritativeProperties = new AuthoritativeMessagesProperties.Parser().parse(this.messagesFile);
        }
        catch (IOException e) {
            throw new MavenReportException(String.format("Failed to parse authoritative messages file: %s", this.messagesFile), (Exception)e);
        }
        try {
            List translationFiles = FileUtils.getFiles((File)this.getProject().getBasedir(), (String)this.translatedMessagesPattern, null);
            translationFiles.remove(this.messagesFile);
            translatedProperties = new TranslatedMessagesProperties.Parser().parse(authoritativeProperties, translationFiles);
        }
        catch (IOException e) {
            throw new MavenReportException(String.format("Failed to parse translated messages files for pattern: %s", this.translatedMessagesPattern), (Exception)e);
        }
        try {
            analysisResults = TranslationKeyAnalysisUtils.getInstance(this.getLog()).analyzeClassiness(classLoader, authoritativeProperties);
        }
        catch (IOException e) {
            throw new MavenReportException(String.format("Failed to verify %s", this.messagesFile), (Exception)e);
        }
        try {
            translationClassKeys = TranslationClassUtils.getTranslationKeys(this.keyClasses, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new MavenReportException("Failed to translate key classes: " + this.keyClasses, (Exception)e);
        }
        translationClassKeys.removeAll(authoritativeProperties.getTranslationKeys());
        new ReportRenderer(this, locale, this.getSink(), authoritativeProperties, analysisResults, translatedProperties, translationClassKeys).render();
    }

    static class ReportRenderer
    extends AbstractMavenReportRenderer {
        private final TranslationKeyVerifier mojo;
        private final Locale locale;
        private final AuthoritativeMessagesProperties authoritativeProperties;
        private final SortedSet<MissingTranslationKey> missingTranslationKeys;
        private final SortedSet<MissingTranslationKeyClass> missingTranslationKeyClasses;
        private final SortedSet<TranslatedMessagesProperties> translatedProperties;
        private final SortedSet<String> messagelessKeys;

        ReportRenderer(TranslationKeyVerifier mojo, Locale locale, Sink sink, AuthoritativeMessagesProperties authoritativeProperties, TranslationKeyAnalysisUtils.ClassinessAnalysisResults analysisResults, Collection<TranslatedMessagesProperties> translatedProperties, Collection<String> messagelessKeys) {
            super(sink);
            this.mojo = mojo;
            this.locale = locale;
            this.authoritativeProperties = authoritativeProperties;
            this.missingTranslationKeyClasses = new TreeSet<MissingTranslationKeyClass>(analysisResults.getMissingTranslationKeyClasses());
            this.missingTranslationKeys = new TreeSet<MissingTranslationKey>(analysisResults.getMissingTranslationKeys());
            this.translatedProperties = new TreeSet<TranslatedMessagesProperties>(translatedProperties);
            this.messagelessKeys = new TreeSet<String>(messagelessKeys);
        }

        public String getTitle() {
            return this.mojo.getName(this.locale);
        }

        protected void renderBody() {
            this.sink.sectionTitle1();
            this.sink.text(this.mojo.getName(this.locale));
            this.sink.sectionTitle1_();
            this.sink.paragraph();
            this.sink.text("This report describes translation keys listed in your messages properties file that are in an invalid state.");
            this.sink.paragraph_();
            this.sink.sectionTitle2();
            this.sink.text("Messageless Keys");
            this.sink.sectionTitle2_();
            this.sink.paragraph();
            if (this.messagelessKeys.isEmpty()) {
                this.sink.text("There are no translation key classes defined or there are none missing properties file entries.");
            } else {
                this.sink.text("The following are fields of translation classes that were not found to have any corresponding entries in the authoritative messages properties file.");
                this.sink.table();
                super.tableHeader(new String[]{"Translation Key"});
                for (String messagelessKey : this.messagelessKeys) {
                    super.tableRow(new String[]{messagelessKey});
                }
                this.sink.table_();
            }
            this.sink.paragraph_();
            this.sink.sectionTitle2();
            this.sink.text("Duplicate Translation Keys");
            this.sink.sectionTitle2_();
            this.sink.paragraph();
            if (this.authoritativeProperties.getDuplicateTranslationKeys().isEmpty()) {
                this.sink.text("No duplicate translation keys were found.");
            } else {
                this.sink.text("The following duplicate translation keys were found in your messages properties file.");
                this.sink.table();
                super.tableHeader(new String[]{"Translation Key"});
                for (String duplicate : this.authoritativeProperties.getDuplicateTranslationKeys()) {
                    super.tableRow(new String[]{duplicate});
                }
                this.sink.table_();
            }
            this.sink.paragraph_();
            this.sink.sectionTitle2();
            this.sink.text("Missing Translation Classes");
            this.sink.sectionTitle2_();
            this.sink.paragraph();
            if (this.missingTranslationKeyClasses.isEmpty()) {
                this.sink.text("No missing translation key classes were found.");
            } else {
                this.sink.text("The following is a list of classes that are listed in your messages properties file, but are not found to actually exist.");
                this.sink.table();
                super.tableHeader(new String[]{"Class Name"});
                for (MissingTranslationKeyClass keyClass : this.missingTranslationKeyClasses) {
                    super.tableRow(new String[]{keyClass.getClassName()});
                }
                this.sink.table_();
            }
            this.sink.paragraph_();
            this.sink.sectionTitle2();
            this.sink.text("Missing Translation Keys");
            this.sink.sectionTitle2_();
            this.sink.paragraph();
            if (this.missingTranslationKeys.isEmpty()) {
                this.sink.text("No missing translation keys were found.");
            } else {
                this.sink.text("The following is a list of translation keys that are found in the messages properties file, but were not found to actually exist.");
                this.sink.table();
                super.tableHeader(new String[]{"Class Name", "Key Name"});
                for (MissingTranslationKey key : this.missingTranslationKeys) {
                    super.tableRow(new String[]{key.getClassName(), key.getKeyName()});
                }
                this.sink.table_();
            }
            this.sink.paragraph_();
            this.sink.sectionTitle2();
            this.sink.text("Authoritative Messages Statistics");
            this.sink.sectionTitle2_();
            this.sink.paragraph();
            this.sink.text("The following describes some statistics and information about the configured 'authoritative' messages properties file.");
            this.sink.paragraph();
            this.sink.table();
            super.tableRow(new String[]{"Filename", this.authoritativeProperties.getFile().getName()});
            if (this.authoritativeProperties.getSupportedLocale() != null) {
                super.tableRow(new String[]{"Supported Language", this.authoritativeProperties.getSupportedLocale().getDisplayLanguage()});
                if (StringUtils.isNotEmpty((CharSequence)this.authoritativeProperties.getSupportedLocale().getCountry())) {
                    super.tableRow(new String[]{"Supported Country", this.authoritativeProperties.getSupportedLocale().getDisplayCountry()});
                }
            }
            super.tableRow(new String[]{"Translation Key Count", Integer.toString(this.authoritativeProperties.getTranslationKeys().size())});
            this.sink.table_();
            this.sink.sectionTitle2();
            this.sink.text("Translated Messages Statistics");
            this.sink.sectionTitle2_();
            if (this.translatedProperties.isEmpty()) {
                this.sink.paragraph();
                this.sink.text("No translations of the configured authoritative messages file were found.");
                this.sink.paragraph_();
            } else {
                this.sink.paragraph();
                this.sink.text("The following describes statistics and information about each of the discovered translations of the authoritative messages properties.");
                this.sink.paragraph_();
                this.sink.paragraph();
                this.sink.text("'Extra translation keys' are keys that are discovered in the translated messages properties, but do not exist in the authoritative message properties.");
                this.sink.paragraph_();
                this.sink.paragraph();
                this.sink.text("'Missing translation keys' are keys that are found in the authoritative messages properties, but are not found in the translation.");
                this.sink.paragraph_();
            }
            for (TranslatedMessagesProperties translatedProperty : this.translatedProperties) {
                this.sink.sectionTitle3();
                this.sink.text(translatedProperty.getFile().getName());
                this.sink.sectionTitle3_();
                this.sink.table();
                if (translatedProperty.getSupportedLocale() != null) {
                    super.tableRow(new String[]{"Supported Language", translatedProperty.getSupportedLocale().getDisplayLanguage()});
                    if (StringUtils.isNotEmpty((CharSequence)translatedProperty.getSupportedLocale().getCountry())) {
                        super.tableRow(new String[]{"Supported Country", translatedProperty.getSupportedLocale().getDisplayCountry()});
                    }
                }
                super.tableRow(new String[]{"Translation Key Count", Integer.toString(translatedProperty.getTranslationKeys().size())});
                super.tableRow(new String[]{"Missing Translation Keys", Integer.toString(translatedProperty.getMissingTranslationKeys().size())});
                super.tableRow(new String[]{"Extra Translation Keys", Integer.toString(translatedProperty.getExtraTranslationKeys().size())});
                int comparativeCount = translatedProperty.getTranslationKeys().size() - translatedProperty.getExtraTranslationKeys().size();
                double percentComplete = (double)comparativeCount / (double)this.authoritativeProperties.getTranslationKeys().size() * 100.0;
                super.tableRow(new String[]{"Translation Completion Percentage", String.format("%.2f", percentComplete) + "%"});
                this.sink.table_();
                this.sink.sectionTitle4();
                this.sink.text("Duplicate Translation Keys");
                this.sink.sectionTitle4_();
                this.sink.paragraph();
                if (translatedProperty.getDuplicateTranslationKeys().isEmpty()) {
                    this.sink.text("No duplicate translation keys were found.");
                } else {
                    this.sink.text("The following duplicate translation keys were found in this messages properties file.");
                    this.sink.table();
                    super.tableHeader(new String[]{"Translation Key"});
                    for (String duplicate : translatedProperty.getDuplicateTranslationKeys()) {
                        super.tableRow(new String[]{duplicate});
                    }
                    this.sink.table_();
                }
                this.sink.paragraph_();
                if (translatedProperty.getMissingTranslationKeys().isEmpty()) continue;
                this.sink.sectionTitle4();
                this.sink.text("Missing Translation Keys");
                this.sink.sectionTitle4_();
                this.sink.table();
                super.tableHeader(new String[]{"Translation Key"});
                for (String missingTranslationKey : translatedProperty.getMissingTranslationKeys()) {
                    super.tableRow(new String[]{missingTranslationKey});
                }
                if (translatedProperty.getMissingTranslationKeys().size() > 10) {
                    super.tableRow(new String[]{String.format("And %d more...", translatedProperty.getMissingTranslationKeys().size() - 10)});
                }
                this.sink.table_();
            }
        }
    }
}

