/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.mojo.report;

import com.github.jrh3k5.plugin.maven.l10n.data.AuthoritativeMessagesProperties;
import com.github.jrh3k5.plugin.maven.l10n.util.ClassLoaderUtils;
import com.github.jrh3k5.plugin.maven.l10n.util.TranslationKeyAnalysisUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="verify-messages", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class VerifyMessagesMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/messages.properties")
    private File messagesFile;
    @Parameter(required=true, defaultValue="false")
    private boolean failBuild;
    @Parameter(required=true, defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TranslationKeyAnalysisUtils.ClassinessAnalysisResults analysisResults;
        AuthoritativeMessagesProperties properties;
        try {
            properties = new AuthoritativeMessagesProperties.Parser().parse(this.messagesFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to parse messages file: %s", this.messagesFile), (Exception)e);
        }
        try {
            analysisResults = TranslationKeyAnalysisUtils.getInstance(this.getLog()).analyzeClassiness(ClassLoaderUtils.getClassLoader(this.project), properties);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to analyze translation keys for file: %s", this.messagesFile), (Exception)e);
        }
        AbstractIssueEmitter emitter = this.failBuild ? new LogErrorIssueEmitter(this.getLog()) : new LogWarnIssueEmitter(this.getLog());
        boolean shouldFail = false;
        if (!properties.getDuplicateTranslationKeys().isEmpty()) {
            shouldFail = true;
            emitter.emit(String.format("File %s contains %d duplicate keys.", this.messagesFile.getName(), properties.getDuplicateTranslationKeys().size()));
        }
        if (!analysisResults.getMissingTranslationKeyClasses().isEmpty()) {
            shouldFail = true;
            emitter.emit(String.format("File %s contains %d references to non-existent translation key classes.", this.messagesFile.getName(), analysisResults.getMissingTranslationKeyClasses().size()));
        }
        if (!analysisResults.getMissingTranslationKeys().isEmpty()) {
            shouldFail = true;
            emitter.emit(String.format("File %s contains %d references to non-existent translation class keys.", this.messagesFile.getName(), analysisResults.getMissingTranslationKeys().size()));
        }
        if (this.failBuild && shouldFail) {
            throw new MojoFailureException(String.format("The file %s has one or more verification errors. Refer to messages above for more information.", this.messagesFile.getName()));
        }
    }

    private static class LogWarnIssueEmitter
    extends AbstractIssueEmitter {
        private final Log log;

        private LogWarnIssueEmitter(Log log) {
            this.log = log;
        }

        @Override
        public void emit(String message) {
            this.log.warn((CharSequence)message);
        }
    }

    private static class LogErrorIssueEmitter
    extends AbstractIssueEmitter {
        private final Log log;

        private LogErrorIssueEmitter(Log log) {
            this.log = log;
        }

        @Override
        public void emit(String message) {
            this.log.error((CharSequence)message);
        }
    }

    private static abstract class AbstractIssueEmitter {
        private AbstractIssueEmitter() {
        }

        public abstract void emit(String var1);
    }
}

