/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public abstract class ClassLoaderUtils {
    public static ClassLoader getClassLoader(MavenProject project) throws IOException {
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        try {
            for (Object dependency : project.getRuntimeClasspathElements()) {
                classpathUrls.add(new File(dependency.toString()).toURI().toURL());
            }
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new IOException("Failed to build project classloader.", e);
        }
        return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]));
    }

    private ClassLoaderUtils() {
    }
}

