/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public abstract class TranslationClassUtils {
    public static Collection<String> getTranslationKeys(Collection<String> classNames, ClassLoader classLoader) throws ClassNotFoundException {
        HashSet<String> translationKeys = new HashSet<String>();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false)}).setUrls((Collection)ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{classLoader})).addClassLoader(classLoader));
        ArrayList clazzes = new ArrayList(classNames.size());
        for (String string : classNames) {
            clazzes.add(classLoader.loadClass(string));
        }
        for (Class clazz : clazzes) {
            for (Class subclazz : reflections.getSubTypesOf(clazz)) {
                for (Field field : subclazz.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    boolean isInstanceOf = false;
                    for (Class clazz2 : clazzes) {
                        try {
                            isInstanceOf |= clazz2.isAssignableFrom(field.get(null).getClass());
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            throw new IllegalArgumentException(String.format("Unable to read class type of field %s.%s", clazz.getCanonicalName(), field.getName()), e);
                        }
                    }
                    if (!isInstanceOf) continue;
                    translationKeys.add(String.format("%s.%s", subclazz.getCanonicalName(), field.getName()));
                }
            }
        }
        return translationKeys;
    }

    private TranslationClassUtils() {
    }
}

