/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrh3k5.plugin.maven.l10n.util;

import com.github.jrh3k5.plugin.maven.l10n.data.AuthoritativeMessagesProperties;
import com.github.jrh3k5.plugin.maven.l10n.data.MissingTranslationKey;
import com.github.jrh3k5.plugin.maven.l10n.data.MissingTranslationKeyClass;
import com.github.jrh3k5.plugin.maven.l10n.data.TranslationClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class TranslationKeyAnalysisUtils {
    private final Log log;

    public static TranslationKeyAnalysisUtils getInstance(Log log) {
        return new TranslationKeyAnalysisUtils(log);
    }

    private TranslationKeyAnalysisUtils(Log log) {
        this.log = log;
    }

    public ClassinessAnalysisResults analyzeClassiness(ClassLoader classLoader, AuthoritativeMessagesProperties messagesProperties) throws IOException {
        ArrayList<MissingTranslationKey> missingTranslationKeys = new ArrayList<MissingTranslationKey>();
        ArrayList<MissingTranslationKeyClass> missingTranslationKeyClasses = new ArrayList<MissingTranslationKeyClass>();
        for (TranslationClass translationClass : messagesProperties.getTranslationClasses()) {
            String className = translationClass.getTranslationClassName();
            Class<?> translationKeyClass = null;
            try {
                translationKeyClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                this.log.debug((CharSequence)String.format("The translation key class %s was not found.", className), (Throwable)e);
                missingTranslationKeyClasses.add(new MissingTranslationKeyClass(className));
                continue;
            }
            for (String keyName : translationClass.getKeyNames()) {
                try {
                    translationKeyClass.getDeclaredField(keyName);
                }
                catch (NoSuchFieldException | SecurityException e) {
                    this.log.debug((CharSequence)String.format("The translation key %s for class %s was not found.", keyName, className), (Throwable)e);
                    missingTranslationKeys.add(new MissingTranslationKey(className, keyName));
                }
            }
        }
        return new ClassinessAnalysisResults(missingTranslationKeyClasses, missingTranslationKeys);
    }

    public static class ClassinessAnalysisResults {
        private final List<MissingTranslationKeyClass> missingTranslationKeyClasses;
        private final List<MissingTranslationKey> missingTranslationKeys;

        private ClassinessAnalysisResults(List<MissingTranslationKeyClass> missingTranslationKeyClasses, List<MissingTranslationKey> missingTranslationKeys) {
            this.missingTranslationKeyClasses = Collections.unmodifiableList(missingTranslationKeyClasses);
            this.missingTranslationKeys = Collections.unmodifiableList(missingTranslationKeys);
        }

        public List<MissingTranslationKey> getMissingTranslationKeys() {
            return this.missingTranslationKeys;
        }

        public List<MissingTranslationKeyClass> getMissingTranslationKeyClasses() {
            return this.missingTranslationKeyClasses;
        }
    }
}

