/*
 * Decompiled with CFR 0.152.
 */
package com.github.jrialland.ajpclient;

import com.github.jrialland.ajpclient.Attribute;
import com.github.jrialland.ajpclient.AttributeType;
import java.util.ArrayList;
import java.util.Collections;

public class AttributeFactory {
    public static Attribute createContextAttribute(String context) {
        return new Attribute(AttributeType.CONTEXT, Collections.singletonList(context));
    }

    public static Attribute createServletPathAttribute(String servletPath) {
        return new Attribute(AttributeType.SERVLET_PATH, Collections.singletonList(servletPath));
    }

    public static Attribute createRemoteUserAttribute(String remoteUser) {
        return new Attribute(AttributeType.REMOTE_USER, Collections.singletonList(remoteUser));
    }

    public static Attribute createAuthTypeAttribute(String authType) {
        return new Attribute(AttributeType.AUTH_TYPE, Collections.singletonList(authType));
    }

    public static Attribute createQueryStringAttribute(String queryString) {
        return new Attribute(AttributeType.QUERY_STRING, Collections.singletonList(queryString));
    }

    public static Attribute createRouteAttribute(String route) {
        return new Attribute(AttributeType.ROUTE, Collections.singletonList(route));
    }

    public static Attribute createSslCertificateAttribute(String sslCertificate) {
        return new Attribute(AttributeType.SSL_CERT, Collections.singletonList(sslCertificate));
    }

    public static Attribute createSslCipherAttribute(String sslCipher) {
        return new Attribute(AttributeType.SSL_CIPHER, Collections.singletonList(sslCipher));
    }

    public static Attribute createSslSessionAttribute(String sslSession) {
        return new Attribute(AttributeType.SSL_SESSION, Collections.singletonList(sslSession));
    }

    public static Attribute createReqAttributeAttribute(String requestAttributeName, String requestAttributeValue) {
        ArrayList<String> requestAttribute = new ArrayList<String>();
        requestAttribute.add(requestAttributeName);
        requestAttribute.add(requestAttributeValue);
        return new Attribute(AttributeType.REQ_ATTRIBUTE, requestAttribute);
    }

    public static Attribute createSslKeySizeAttribute(String sslKeySize) {
        return new Attribute(AttributeType.SSL_KEY_SIZE, Collections.singletonList(sslKeySize));
    }

    public static Attribute createSecretAttribute(String secret) {
        return new Attribute(AttributeType.SECRET, Collections.singletonList(secret));
    }

    public static Attribute createStoredMethodAttribute(String storedMethod) {
        return new Attribute(AttributeType.STORED_METHOD, Collections.singletonList(storedMethod));
    }
}

